#include "HR8P287.h"
#include "macro.h"
#include "typedef.h"
#include "lib_flashiap.h"

#define APP_ADDRESS BOOT_TO_ADDR
typedef  void (*FunVoidType)(void);

static uint32_t ApplicationAddress;
static uint32_t m_JumpAddress;
static FunVoidType JumpToApplication;

/***************************************************************
sfr_reset
  : ǰBootROMʹõļĴָλֵ
ֵ
ֵ
ֵ
***************************************************************/
void sfr_reset(void)
{
    SysTick->CTRL = 0x00;
    SysTick->LOAD = 0;

    UART0->CON.RRST = 1;
    UART0->CON.TRST = 1;
    UART0->CON.Word = 0;
    UART0->IE.Word  = 0;
    UART0->BRR.Word = 0;
    UART0->IF.Word = 0;

    GPIO->PROT.Word = 0x78879669;

    GPIO->PADIR.Word  = 0xFFFFFFFF;
    GPIO->PAPDEN.Word  = 0;
    GPIO->PAFUN0.Word  = 0;
    GPIO->PAFUN2.Word  = 0;
    GPIO->PA.Word = 0;

    GPIO->PROT.Word = 0;

    SCU->PROT.Word = 0;
}

/***************************************************************
JumpToApp
  : ָλ
ֵĿַ256byte
ֵ
ֵ
***************************************************************/
void JumpToApp(uint32_t addr)
{
    __disable_irq(); //ж
    NVIC->ICER[0] = 0xFFFFFFFF;  //رIRQ

    ApplicationAddress = addr & 0xFFFFFF00; //ַ֤256
    REMAP_EN;
    SCU->TBLOFFS.TBLOFF = ApplicationAddress; //жӳ

    m_JumpAddress = *(volatile uint32_t *)(ApplicationAddress + 4);  //ȡλ
    JumpToApplication = (FunVoidType) m_JumpAddress;

    sfr_reset();  //ָĴ
    __enable_irq();  //ʹж

    __set_MSP(*(volatile uint32_t *) ApplicationAddress);  //ʼջ
    JumpToApplication();  //תλָλ
}
