/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  timer.c
*  :  Liut
*  :  V1.00
*  :  2017/06/25
*  :  T32Nģ
*  ע:  HRSDK-GDB-HR8P287 V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "timer.h"

/*********************************************************
: void T32N0CAPInit(void)
  : T32N0ʱʼ ˿0,1أ1
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T32N0CAPInit(void)
{
    TIM_BaseInitStruType x;
    TIM_CapInitStruType y;
    GPIO_InitStruType z;

    GPIO_RegUnLock();
    z.GPIO_Func = GPIO_Func_1;                  //PA26,PA27 ׽
    z.GPIO_Direction = GPIO_Dir_In;
    z.GPIO_PUEN = DISABLE;
    z.GPIO_PDEN = DISABLE;
    z.GPIO_OD = DISABLE;
    GPIO_Init(GPIOA, GPIO_Pin_26, &z);
    GPIO_Init(GPIOA, GPIO_Pin_27, &z);
    GPIO_RegLock();

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_CAP;
    T32Nx_BaseInit(T32N0, &x);

    T32Nx_MAT0ITConfig(T32N0, TIM_Go_No);               //MAT0ƥ
    T32Nx_MAT1ITConfig(T32N0, TIM_Go_No);               //MAT2ƥ
    T32Nx_MAT2ITConfig(T32N0, TIM_Go_No);               //MAT0ƥ
    T32Nx_MAT3ITConfig(T32N0, TIM_Go_No);               //MAT2ƥ

    y.TIM_CapRise = ENABLE;
    y.TIM_CapFall = DISABLE;
    y.TIM_CapIS0 = ENABLE;
    y.TIM_CapIS1 = ENABLE;
    y.TIM_CapTime = TIM_CapTime_1;                      //׽1
    T32Nx_CapInit(T32N0, &y);

    T32Nx_ITConfig(T32N0, TIM_IT_CAP0, ENABLE);         //˿0׽ж
    T32Nx_ITConfig(T32N0, TIM_IT_CAP1, ENABLE);         //˿1׽ж
    NVIC_Init(NVIC_T32N0_IRQn, NVIC_Priority_1, ENABLE); //ж
    T32N0_Enable();                                     //ʹܶʱ
}
/*********************************************************
: void T32N1CAPInit(void)
  : T32N1ʱʼ ˿0,1½أ2
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T32N1CAPInit(void)
{
    TIM_BaseInitStruType x;
    TIM_CapInitStruType y;
    GPIO_InitStruType z;

    GPIO_RegUnLock();
    z.GPIO_Func = GPIO_Func_1;                          //PA12,PA13
    z.GPIO_Direction = GPIO_Dir_In;
    z.GPIO_PUEN = DISABLE;
    z.GPIO_PDEN = DISABLE;
    z.GPIO_OD = DISABLE;
    GPIO_Init(GPIOA, GPIO_Pin_12, &z);
    GPIO_Init(GPIOA, GPIO_Pin_13, &z);
    GPIO_RegLock();

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_CAP;
    T32Nx_BaseInit(T32N1, &x);

    T32Nx_MAT0ITConfig(T32N1, TIM_Go_No);               //MAT0ƥ
    T32Nx_MAT1ITConfig(T32N1, TIM_Go_No);               //MAT2ƥ
    T32Nx_MAT2ITConfig(T32N1, TIM_Go_No);               //MAT0ƥ
    T32Nx_MAT3ITConfig(T32N1, TIM_Go_No);               //MAT2ƥ

    y.TIM_CapRise = DISABLE;
    y.TIM_CapFall = ENABLE;
    y.TIM_CapIS0 = ENABLE;
    y.TIM_CapIS1 = ENABLE;
    y.TIM_CapTime = TIM_CapTime_2;                      //׽2
    T32Nx_CapInit(T32N1, &y);

    T32Nx_ITConfig(T32N1, TIM_IT_CAP0, ENABLE);         //˿0׽ж
    T32Nx_ITConfig(T32N1, TIM_IT_CAP1, ENABLE);         //˿1׽ж
    NVIC_Init(NVIC_T32N1_IRQn, NVIC_Priority_1, ENABLE); //ж
    T32N1_Enable();                                     //ʹܶʱ
}

/*********************************************************
: void T32N2CAPInit(void)
  : T32N2ʱʼ ˿0,1+½أ8
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T32N2CAPInit(void)
{
    TIM_BaseInitStruType x;
    TIM_CapInitStruType y;
    GPIO_InitStruType z;

    GPIO_RegUnLock();
    z.GPIO_Func = GPIO_Func_1;  //      PB8,PB9
    z.GPIO_Direction = GPIO_Dir_In;
    z.GPIO_PUEN = DISABLE;
    z.GPIO_PDEN = DISABLE;
    z.GPIO_OD = DISABLE;
    GPIO_Init(GPIOB, GPIO_Pin_8, &z);
    GPIO_Init(GPIOB, GPIO_Pin_9, &z);
    GPIO_RegLock();

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_CAP;
    T32Nx_BaseInit(T32N2, &x);

    T32Nx_MAT0ITConfig(T32N2, TIM_Go_No);               //MAT0ƥ
    T32Nx_MAT1ITConfig(T32N2, TIM_Go_No);               //MAT1ƥ
    T32Nx_MAT2ITConfig(T32N2, TIM_Go_No);               //MAT2ƥ
    T32Nx_MAT3ITConfig(T32N2, TIM_Go_No);               //MAT3ƥ

    y.TIM_CapRise = ENABLE;
    y.TIM_CapFall = ENABLE;
    y.TIM_CapIS0 = ENABLE;
    y.TIM_CapIS1 = ENABLE;
    y.TIM_CapTime = TIM_CapTime_8;                      //׽8
    T32Nx_CapInit(T32N2, &y);

    T32Nx_ITConfig(T32N2, TIM_IT_CAP0, ENABLE);         //˿0׽ж
    T32Nx_ITConfig(T32N2, TIM_IT_CAP1, ENABLE);         //˿1׽ж
    NVIC_Init(NVIC_T32N2_IRQn, NVIC_Priority_1, ENABLE); //ж
    T32N2_Enable();                                     //ʹܶʱ
}
