/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  sleep.c
*  :
*  :  V1.00
*  :  2018/05/3
*  :
*  ע:  HRSDK-GDB-HR8P287 V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "sleep.h"

/*********************************************************
: void Sleep(uchar mode)
  : ģʽӳ
ֵ: mode - IDLEģʽ
ֵ: 
ֵ: 
**********************************************************/
void Sleep(uint8_t mode)
{
    uint32_t i;
    GPIO_InitStruType y;
    __disable_irq(); //رIRQж
    WDT_Clear();  //幷
    DeviceClockAllEnable();
    KINTInit();                         //ʼKINT
    GPIO_RegUnLock();
    y.GPIO_Func = GPIO_Func_0;
    y.GPIO_Direction = GPIO_Dir_Out;
    y.GPIO_OD = DISABLE;
    y.GPIO_PDEN = DISABLE;
    y.GPIO_PUEN = DISABLE;
    GPIOA_SetBit(GPIO_Pin_23);
    GPIO_Init(GPIOA, GPIO_Pin_23, &y); //PA23Ϊ

    SCU_RegUnLock();
    SCU_LVDVS_4V1();    //LVDѵѹ4.1V
    SCU_LVDIFS_Fall(); //LVDѹ߼
    SCU_LVDFLT_Enable(); //LVD˲ʹ
    SCU_LVD_Enable(); //LVDжʹ



    RTC_Init(RTC_LOSC, RTC_HOUR24); //ʵʱʱӳʼLOSCʱӣ
    //RTC_Init(RTC_LRC,RTC_HOUR24);//ʵʱʱӳʼ(LRCʱ)
    RTC_WriteSecond(30);
    RTC_InterruptEnable(RTC_Interrupt_Source_Second);//ʹʵʱʱӵж

    NVIC_EnableIRQ(LVDINT_IRQn);   //ʹLVDԴ
    NVIC_EnableIRQ(PINT4_IRQn); //ʹܰ
    NVIC_EnableIRQ(WDTINT_IRQn);  //ʹWDTԴ
    NVIC_EnableIRQ(RTCINT_IRQn);  //ʹ뻽Դ

    if (1 == mode)
    {
        SCU_RegUnLock();
        SCB_SystemLPConfig(SCB_LP_SleepDeep, ENABLE);   //Ϊ˯ģʽ
        SCU->PCLKEN0.Word = 0x000000A3;         //رʱӣscu޷رգͬʱGPIOʱӹⲿжϻ???
        SCU->PCLKEN1.Word = 0x00000000;
        SCU_RegLock();
    }

    while (1) //ѭ
    {
        NVIC->ICPR[0] = 0XFFFFFFFF; //NVICʶ
        __NOP();
        __NOP();
			  __WFI();
//        idle();
        __NOP();
        __NOP();

        if (WDT_GetFlagStatus() != RESET)
        {
            WDT_Clear();   //幷
        }

        if (SCU_GetLVDFlagStatus(SCU_LVDFlag_IF) != RESET) //LVD
        {
            SCU_RegUnLock();
            SCU_LVDClearIFBit();
            SCU_RegLock();
            NVIC_SystemReset();   //λ
        }

        if (RTC_GetFlagStatus(RTC_Interrupt_Source_Second) != RESET
                && RTC_GetITStatus(RTC_Interrupt_Source_Second) != RESET)  //뻽
        {
            RTC->IF.Word = 1U << 0; //жϱʶ
            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת
        }

        if (PINT_GetITStatus(PINT_IT_PINT4) != RESET)  //KINT
        {
            PINT_ClearITPendingBit(PINT_IT_PINT4);
            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת

            for (i = 0; i < 165350; i++);

            GPIOA_ToggleBit(GPIO_Pin_23);  //PA23ת
        }
    }

}
