/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  lcd.c
*  :  Liut
*  :  V1.00
*  :  2017/06/25
*  :  LCDģ
*  ע:  HRSDK-GDB-HR8P287 V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "lcd.h"

const uint16_t LCD7Code[] =
{
    0x070D,                 //0
    0x0005,                 //1
    0x050B,                 //2
    0x010F,                 //3
    0x0207,                 //4
    0x030E,                 //5
    0x070E,                 //6
    0x0105,                 //7
    0x070F,                 //8
    0x030F,                 //9
    0x0707,                 //A
    0x060E,                 //B
    0x0708,                 //C
    0x040F,                 //D
    0x070A,                 //E
    0x0702                  //F
};

/*********************************************************
: void LCDInit(void)
  : LCDʾʼӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void LCDInit(void)
{
    GPIO_InitStruType x;
    LCD_InitStruType y;

    GPIO_RegUnLock();
    x.GPIO_Func = GPIO_Func_3;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PUEN = DISABLE;
    x.GPIO_PDEN = DISABLE;
    x.GPIO_OD = DISABLE;

    GPIO_Init(GPIOB, GPIO_Pin_0, &x);           //LCD  PB0 1 2 3 8 9 10 11 12 13 14 15
    GPIO_Init(GPIOB, GPIO_Pin_1, &x);
    GPIO_Init(GPIOB, GPIO_Pin_2, &x);
    GPIO_Init(GPIOB, GPIO_Pin_3, &x);

    GPIO_Init(GPIOB, GPIO_Pin_8, &x);
    GPIO_Init(GPIOB, GPIO_Pin_9, &x);
    GPIO_Init(GPIOB, GPIO_Pin_10, &x);
    GPIO_Init(GPIOB, GPIO_Pin_11, &x);
    GPIO_Init(GPIOB, GPIO_Pin_12, &x);
    GPIO_Init(GPIOB, GPIO_Pin_13, &x);
    GPIO_Init(GPIOB, GPIO_Pin_14, &x);
    GPIO_Init(GPIOB, GPIO_Pin_15, &x);
    GPIO_RegLock();

    y.LCD_Coms = LCD_Coms_4;                    //ѡcom0~com3
    y.LCD_LcdFlik = DISABLE;                    //˸ֹ
    y.LCD_LcdWFS = LCD_WaveMode_A;              //AͲ
    y.LCD_Bias = LCD_Bias_3;                    //1/3ѹƫ
    y.LCD_RS = LCD_Res_15k;                     //15kƫѹ
    y.LCD_Grayscale = LCD_Grayscale_32_36_VLCD; //Ҷѡ
    y.LCD_BIAS_SEL = LCD_BiasSel_1;             //ڲƫʹΪ1
    y.LCD_PRS = 35;                             //ʱӷƵ
    y.LCD_SEG0 = 0x0FF;                         //LCDʹλ
    y.LCD_SEG1 = 0;
    LCD_Init(&y, Sel_0);

    LCD_Enable();        //LCDʹ
}

/*********************************************************
: void LCDDisplayData(uint8_t high, uint8_t low, uint8_t colon)
  : LCDʾӳ
ֵ: high_byteʾֽ
        low_byteʾֽ
        colonʾð
ֵ: 
ֵ: 
**********************************************************/
void LCDDisplayData(uint8_t high, uint8_t low, uint8_t colon)
{
    uint8_t temp_data;

    temp_data = (low % 10);                     //ȡǧλ
    LCD_PixelWriteHalfWord(LCD_Pixel_LCDD0, LCD_HalfWord_0, LCD7Code[temp_data]);

    temp_data = (low / 10);                     //ȡλ
    LCD_PixelWriteHalfWord(LCD_Pixel_LCDD0, LCD_HalfWord_1, LCD7Code[temp_data]);

    temp_data = (high % 10);                    //ȡʮλ
    LCD_PixelWriteHalfWord(LCD_Pixel_LCDD1, LCD_HalfWord_0, LCD7Code[temp_data]);

    if (colon)                                  //ð״̬
        LCD_PixelWriteHalfWord(LCD_Pixel_LCDD1, LCD_HalfWord_0, (LCD7Code[temp_data] | 0x0008));
    else
        LCD_PixelWriteHalfWord(LCD_Pixel_LCDD1, LCD_HalfWord_0, (LCD7Code[temp_data] & 0xFFF7));

    temp_data = (high / 10);                    //ȡλ
    LCD_PixelWriteHalfWord(LCD_Pixel_LCDD1, LCD_HalfWord_1, LCD7Code[temp_data]);
}
