/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  adc.c
*  :  Liut
*  :  V1.00
*  :  2017/06/22
*  :  ADCģ
*  ע:  HRSDK-GDB-HR8P287 V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "adc.h"

/*********************************************************
: void ADC0_UserInit(void)
  : ADCʼ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void ADC0_UserInit(void)
{
    GPIO_InitStruType x;
    ADC_InitStruType y;

    GPIO_RegUnLock();
    x.GPIO_Func = GPIO_Func_3;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_PUEN = DISABLE;
    x.GPIO_PDEN = DISABLE;
    x.GPIO_OD = DISABLE;
    GPIO_Init(GPIOA, GPIO_Pin_2, &x);       //PA2
    GPIO_RegLock();

    y.ADC_ClkS = ADC_ClkS_Pclk;             //ʱӣPCLK
    y.ADC_ClkDiv = ADC_ClkDiv_32;           //ԤƵ1:32  ADCתʱԴһҪֲADCתʱԴѡ
    y.ADC_Align = ADC_Align_Right;          //룺Ҷ루Ͷ룩
    y.ADC_VrefP = ADC_VrefP_Ref;            //οѹڲοѹVref 2.5V, AVREFP˿ڸΪͨIO
    y.ADC_SampS = ADC_Samp_Hardware;        //ADģʽѡӲ
    y.ADC_SampClk = ADC_SampClk_16;         //ADʱѡ16TadClk
    y.ADC_ChS = ADC_Ch_2;                   //ͨ:AIN2
    y.ADC_Buf = ADC_BUFF_0ua;
    ADC_Init(&y);                           //սṹĲADC

    ADC_IT_Disable();                       //ʹж

    ADC_Enable();                           //ʹADC
}

/*********************************************************
: uint16_t ADCRead(void)
  : ȡADCֵ˲
ֵ: 
ֵ: 
ֵ: ֵ
**********************************************************/
uint16_t ADCRead(void)
{
    uint8_t i;
    uint16_t max, min, sum, ad_temp;

    max = 0x00;
    min = 0x0fff;
    sum = 0x00;

    for (i = 0; i < 18; i++)
    {
        ADC_Start();

        while (ADC_GetConvStatus() == SET);

        ADC_ClearITPendingBit();

        ad_temp = ADC_GetConvValue();

        if (ad_temp > max)
        {
            max = ad_temp;
        }

        if (ad_temp < min)
        {
            min = ad_temp;
        }

        sum += ad_temp;
    }

    sum -= min;
    sum -= max;
    return sum >> 4;
}
