/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  led.c
*  :  Liut
*  :  V1.00
*  :  2017/06/25
*  :  LEDģ
*  ע:  HRSDK-GDB-HR8P287 V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "led.h"

const uint8_t LED7Code[] =
{
    0x7E,     // 0
    0x0C,     // 1
    0xB6,     // 2
    0x9E,     // 3
    0xCC,     // 4
    0xDA,     // 5
    0xFA,     // 6
    0x0E,     // 7
    0xFE,     // 8
    0xDE,     // 9
    0xEE,     // A
    0xF8,     // B
    0x72,     // C
    0xBC,     // D
    0xF2,     // E
    0xE2,     // F
    0x00     // 16=blank
};

/*********************************************************
: void LEDInit(void)
  : LEDܳʼ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void LEDInit(void)
{
    GPIO_InitStruType x;

    GPIO_RegUnLock();
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PUEN = DISABLE;
    x.GPIO_PDEN = ENABLE;
    x.GPIO_OD = DISABLE;

    GPIO_Init(GPIOB, GPIO_Pin_8, &x);   //LED SEG0~SEG7 PB8 9 10 11 12 13 14 15 ,DIG0~DIG3 PA 29 28 27 26
    GPIO_Init(GPIOB, GPIO_Pin_9, &x);
    GPIO_Init(GPIOB, GPIO_Pin_10, &x);
    GPIO_Init(GPIOB, GPIO_Pin_11, &x);
    GPIO_Init(GPIOB, GPIO_Pin_12, &x);
    GPIO_Init(GPIOB, GPIO_Pin_13, &x);
    GPIO_Init(GPIOB, GPIO_Pin_14, &x);
    GPIO_Init(GPIOB, GPIO_Pin_15, &x);

    GPIO_Init(GPIOA, GPIO_Pin_26, &x);
    GPIO_Init(GPIOA, GPIO_Pin_27, &x);
    GPIO_Init(GPIOA, GPIO_Pin_28, &x);
    GPIO_Init(GPIOA, GPIO_Pin_29, &x);

    GPIO_RegLock();
}

/*********************************************************
: void LEDDisplayData(uint8_t com, uint8_t dat)
  : LEDʾ
ֵ: ѡλҪʾ
ֵ: 
ֵ: 
**********************************************************/
void LEDDisplayData(uint8_t com, uint8_t dat)
{
    uint8_t seg;

    GPIOA_SetBit(GPIO_Pin_29);
    GPIOA_SetBit(GPIO_Pin_28);
    GPIOA_SetBit(GPIO_Pin_27);
    GPIOA_SetBit(GPIO_Pin_26);

    seg = LED7Code[dat];
    LEDDisplaySeg(seg);

    switch (com)
    {
        case 0:
            GPIOA_ResetBit(GPIO_Pin_29);
            break;

        case 1:
            GPIOA_ResetBit(GPIO_Pin_28);
            break;

        case 2:
            GPIOA_ResetBit(GPIO_Pin_27);
            break;

        case 3:
            GPIOA_ResetBit(GPIO_Pin_26);
            break;
    }
}

/*********************************************************
: void LEDDisplaySeg(uint8_t seg)
  : LEDʾSEG
ֵ: seg
ֵ: 
ֵ: 
**********************************************************/
void LEDDisplaySeg(uint8_t seg)
{
    if (seg & 0x01)                     //SEGH
        GPIOB_SetBit(GPIO_Pin_13);
    else
        GPIOB_ResetBit(GPIO_Pin_13);

    if (seg & 0x02)                     //SEGA
        GPIOB_SetBit(GPIO_Pin_8);
    else
        GPIOB_ResetBit(GPIO_Pin_8);

    if (seg & 0x04)                     //SEGB
        GPIOB_SetBit(GPIO_Pin_10);
    else
        GPIOB_ResetBit(GPIO_Pin_10);

    if (seg & 0x08)                     //SEGC
        GPIOB_SetBit(GPIO_Pin_12);
    else
        GPIOB_ResetBit(GPIO_Pin_12);

    if (seg & 0x10)                     //SEGD
        GPIOB_SetBit(GPIO_Pin_14);
    else
        GPIOB_ResetBit(GPIO_Pin_14);

    if (seg & 0x20)                     //SEGE
        GPIOB_SetBit(GPIO_Pin_15);
    else
        GPIOB_ResetBit(GPIO_Pin_15);

    if (seg & 0x40)                     //SEGF
        GPIOB_SetBit(GPIO_Pin_9);
    else
        GPIOB_ResetBit(GPIO_Pin_9);

    if (seg & 0x80)                     //SEGG
        GPIOB_SetBit(GPIO_Pin_11);
    else
        GPIOB_ResetBit(GPIO_Pin_11);
}

/*********************************************************
: void DispHextoBcd(uint32_t hex_data, uint8_t *bcd_data)
  : ʮתBCD
ֵ: ʮ
ֵ: bcd
ֵ: 
**********************************************************/
void DispHextoBcd(uint32_t hex_data, uint8_t *bcd_data)
{
    uint32_t hex_temp;

    hex_temp = hex_data;
    *(bcd_data + 0) = 0;
    *(bcd_data + 1) = 0;
    *(bcd_data + 2) = 0;
    *(bcd_data + 3) = 0;

    while (hex_temp >= 1000)
    {
        hex_temp -= 1000;
        *(bcd_data + 0) += 1;
    }

    while (hex_temp >= 100)
    {
        hex_temp -= 100;
        *(bcd_data + 1) += 1;
    }

    while (hex_temp >= 10)
    {
        hex_temp -= 10;
        *(bcd_data + 2) += 1;
    }

    *(bcd_data + 3) = hex_temp;
}

