/***************************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ  lib_scu.c
*  ߣ  WangBJ
*    V1.00
*  ڣ  2014/10/24
*    ϵͳģ⺯
*  ע   HR8P287оƬ
           ѧϰʾʹãûֱôķջеκηΡ
***************************************************************/

#include "lib_scu.h"
#include "lib_gpio.h"
#include "system_HR8P287.h"

/***************************************************************
SCU_NMISelect
  NMIж
ֵж
ֵ
ֵ
***************************************************************/
void SCU_NMISelect(SCU_TYPE_NMICS NMI_Type)
{
		SCU_RegUnLock();           //SCUдر
    SCU->NMIC.NMICS = NMI_Type;
		SCU_RegLock();             //SCUдʹ
}

/***************************************************************
SCU_GetPWRCFlagStatus
  ȡPWRCλ״̬Ĵ־λ״̬
ֵPWRCĴ־λ
ֵ
ֵRESET/SET
***************************************************************/
FlagStatus  SCU_GetPWRCFlagStatus(SCU_TYPE_PWRC PWRC_Flag)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->PWRC.Word & (uint32_t)PWRC_Flag) != (uint32_t)RESET)
    {
        bitstatus = SET;
    }
    else
    {
        bitstatus = RESET;
    }

    return  bitstatus;
}

/***************************************************************
SCU_ClearPWRCFlagBit
  PWRCλ״̬Ĵ־λ
ֵPWRCĴ־λ
ֵ
ֵ
***************************************************************/
void SCU_ClearPWRCFlagBit(SCU_TYPE_PWRC PWRC_Flag)
{
		SCU_RegUnLock();           //SCUдر
    SCU->PWRC.Word &= ~((uint32_t)PWRC_Flag);
		SCU_RegLock();             //SCUдʹ
}

/***************************************************************
SCU_GetLVDFlagStatus
  ȡLVDDĴ־λ״̬
ֵLVDĴ־λ
ֵ
ֵRESET/SET
***************************************************************/
FlagStatus  SCU_GetLVDFlagStatus(SCU_TYPE_LVD0CON LVD_Flag)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->LVDC.Word & (uint32_t)LVD_Flag) != (uint32_t)RESET)
    {
        bitstatus = SET;
    }
    else
    {
        bitstatus = RESET;
    }

    return  bitstatus;
}

/***************************************************************
SCU_GetCFGWord
  ȡоƬ
ֵ
ֵ
ֵ32λ
***************************************************************/
uint32_t SCU_GetCFGWord(void)
{
    return (SCU->CFGWORD0.Word);
}

/***************************************************************
SCU_SysClkSelect
  ϵͳʱѡ
ֵʱԴ
ֵ
ֵ
***************************************************************/
void SCU_SysClkSelect(SCU_TYPE_SYSCLK Sysclk)
{
		SCU_RegUnLock();           //SCUдر
    SCU->SCLKEN0.SYSCLK_SSE = Sysclk;
		SCU_RegLock();             //SCUдʹ
}

/***************************************************************
SCU_GetSysClk
  ȡϵͳʱԴ
ֵ
ֵ
ֵϵͳʱԴ
***************************************************************/
SCU_TYPE_SYSCLK SCU_GetSysClk(void)
{
    return (SCU_TYPE_SYSCLK)(SCU->SCLKEN0.SYSCLK_SST);
}

/***************************************************************
SCU_SysClkChangeBusy
  ȡϵͳʱл־λ
ֵ
ֵ
ֵRESET/SET
***************************************************************/
FlagStatus SCU_SysClkChangeBusy(void)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->SCLKEN0.SYSCLK_CHG) != (uint32_t)RESET)
    {
        bitstatus = SET;
    }
    else
    {
        bitstatus = RESET;
    }

    return  bitstatus;
}

/***************************************************************
SCU_GetHRCFlag
  ȡHRC־λ
ֵ
ֵ
ֵRESET/SET
***************************************************************/
FlagStatus  SCU_GetHRCFlag(void)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->SCLKEN0.HRC_ON) != (uint32_t)RESET)
    {
        bitstatus = SET;
    }
    else
    {
        bitstatus = RESET;
    }

    return  bitstatus;
}

/***************************************************************
SCU_GetLRCFlag
  ȡLRC־λ
ֵ
ֵ
ֵRESET/SET
***************************************************************/
FlagStatus  SCU_GetLRCFlag(void)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->SCLKEN0.LRC_ON) != (uint32_t)RESET)
    {
        bitstatus = SET;
    }
    else
    {
        bitstatus = RESET;
    }

    return  bitstatus;
}



/***************************************************************
SCU_HOSCReadyFlag
  ȡHOSCȶ־λ
ֵ
ֵ
ֵRESETȶ/SETȶ
***************************************************************/
FlagStatus  SCU_HOSCReadyFlag(void)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->SCLKEN1.HOSC_RDY) != (uint32_t)RESET)
    {
        bitstatus = SET;
    }
    else
    {
        bitstatus = RESET;
    }

    return  bitstatus;
}

/***************************************************************
SCU_LOSCReadyFlag
  ȡLOSCȶ־λ
ֵ
ֵ
ֵRESETȶ/SETȶ
***************************************************************/
FlagStatus  SCU_LOSCReadyFlag(void)
{
    FlagStatus bitstatus = RESET;

    if ((SCU->SCLKEN1.LOSC_RDY) != (uint32_t)RESET)
    {
        bitstatus = SET;
    }
    else
    {
        bitstatus = RESET;
    }

    return  bitstatus;

}

/***************************************************************
SCU_LOSCReadyFlag
  ȡLOSCȶ־λ
ֵ
ֵ
ֵRESETȶ/SETȶ
***************************************************************/
FlagStatus  SCU_PLLReadyFlag(void)
{
    FlagStatus bitstatus = RESET;
    
    return  bitstatus;
}

/***************************************************************
SystemClockConfig
  ϵͳʱãڲʱӣ16MHZʱ
ֵ
ֵ
ֵ
***************************************************************/
void SystemClockConfig(void)
{
    uint32_t Prot_Temp;

    Prot_Temp = SCU->PROT.PROT;

    if (Prot_Temp != 0)  //д
    {
        SCU_RegUnLock();   //
    }

    SCU_HRC_Enable();                      //ʹڲ16MHZ

    while (SCU_GetHRCFlag() != SET);     //ȴʱӿ

    SCU_SysClkSelect(SCU_SysClk_HRC);    //ѡڲ16MHZΪϵͳʱ

    while (SCU_SysClkChangeBusy() != RESET); //ȴл

    SCU_PLL_Disable();
    SCU_SysClk_Div1();                        //ϵͳʱӺƵ1:1

    SystemCoreClock = 16000000;

    if (Prot_Temp != 0)  //д
    {
        SCU_RegLock();   //д
    }
}

/***************************************************************
DeviceClockAllEnable
  ʱ
ֵ
ֵ
ֵ
***************************************************************/
void DeviceClockAllEnable(void)
{
    uint32_t Prot_Temp;

    Prot_Temp = SCU->PROT.PROT;

    if (Prot_Temp != 0)  //д
    {
        SCU_RegUnLock();   //
    }

    SCU->PCLKEN0.Word = 0x000000f7;
    SCU->PCLKEN1.Word = 0x111F070F;        //ʱ

    if (Prot_Temp != 0)  //д
    {
        SCU_RegLock();   //д
    }
}

/***************************************************************
DeviceClockAllDisable
  رʱ
ֵ
ֵ
ֵ
***************************************************************/
void DeviceClockAllDisable(void)
{
    uint32_t Prot_Temp;

    Prot_Temp = SCU->PROT.PROT;

    if (Prot_Temp != 0)  //д
    {
        SCU_RegUnLock();   //
    }

    SCU->PCLKEN0.Word = 0x00000000;     //رʱӣscu޷ر
    SCU->PCLKEN0.Word = 0x00000000;

    if (Prot_Temp != 0)  //д
    {
        SCU_RegLock();   //д
    }
}


/***************************************************************
SystemClockConfig
  ϵͳʱѡ
ֵCLKx ϵͳʱԴѡ
ֵ
ֵ
***************************************************************/
void SystemClockSelect(SCU_TYPE_SYSCLK CLKx)
{
    uint32_t sysclk;
    sysclk = CLKx;
    SCU_RegUnLock(); //

    switch (sysclk)
    {
        case 0:
            SCU_HRC_Enable();

            while (SCU_GetHRCFlag() != SET);

            break;

        case 1:
            SCU_LRC_Enable();

            while (SCU_GetLRCFlag() != SET);

            break;

        case 2:
            SCU_HOSC_Enable();

            while (SCU_HOSCReadyFlag() != SET);

            break;

        case 3:
            SCU_PLL_Enable();

            while (SCU_PLLReadyFlag() != SET);

            break;

        case 4:
            SCU_LOSCLP_Enable();

            while (SCU_LOSCReadyFlag() != SET);

            break;

        default:
            break;
    }

    SCU_SysClkSelect(CLKx);

    while (SCU_SysClkChangeBusy() != RESET); //ȴл

    SCU_RegLock();
}

/***************************************************************
SysclkPLL
  ϵͳʱ໷Ƶ
ֵCLKx:PLLʱԴѡmodePLLʧʱĴģʽ
ֵ
ֵ
***************************************************************/
void SysclkPLL(PLL_TYPE_CLK CLKx, PLL_TYPE_UNLOCK mode)
{
        uint16_t i = 0;
    
        if (CLKx == PLL_LOSC) {
            SCU_LOSCLP_Enable();
        }

        SCU_RegUnLock();   //
        SCU->SCLKEN1.PLL_SSE = CLKx;
        SCU->SCLKEN1.PLL_ULOCK_SET = PLL_UNLOCK_Mode0;
        SCU_PLL_Enable();
    
        for (i = 0; i < 500; ++i)
            __NOP();
        
        SCU_SysClkSelect(SCU_SysClk_PLLCLK);			//ϵͳʱѡ

        while (SCU_SysClkChangeBusy() != RESET);

        SCU->SCLKEN1.PLL_ULOCK_SET = mode;
        SCU_RegLock();   //
}
/*************************END OF FILE**********************/



