/***************************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ  lib_euart.c
*  :  ZouX
*  :  V1.00
*  :  2015/02/03
*    Euartģ⺯
*  ע   HR8P287оƬ
           ѧϰʾʹãûֱôķջеκηΡ
***************************************************************/

#include "lib_euart.h"
#include "system_hr8p287.h"
/***************************************************************
EUART_ModeConfig
  EUARTģʽѡ
ֵEUARTxEUART0  Modeģʽ
ֵ
ֵ
***************************************************************/
void EUART_ModeConfig(EUART_TypeDef *EUARTx, EUART_TYPE_MODE Mode)
{
    EUARTx->MOD.MOD  =  Mode;
}

/***************************************************************
EUART_Init
  EUARTʼ
ֵEUARTxEUART0  EUART_InitStructʼýṹַ
ֵ
ֵ
***************************************************************/
void EUART_Init(EUART_TypeDef *EUARTx, EUART_InitStruType *EUART_InitStruct)
{
    uint32_t BaudTemp = 0, BaudClockTemp = 0;
	
    if (EUART_InitStruct->EUART_ClockSet == EUART_Clock_1)
    {
        BaudClockTemp = (SystemCoreClock / 16) % EUART_InitStruct->EUART_BaudRate;

        if (EUART_InitStruct->EUART_BaudRate >= (2 * BaudClockTemp))
        {
            BaudTemp = (SystemCoreClock / 16 / EUART_InitStruct->EUART_BaudRate) - 1;
        }
        else
        {
            BaudTemp = SystemCoreClock / 16 / EUART_InitStruct->EUART_BaudRate;
        }
    }
    else if (EUART_InitStruct->EUART_ClockSet == EUART_Clock_2)
    {
        BaudClockTemp = (SystemCoreClock / 32) % EUART_InitStruct->EUART_BaudRate;

        if (EUART_InitStruct->EUART_BaudRate >= (2 * BaudClockTemp))
        {
            BaudTemp = (SystemCoreClock / 32 / EUART_InitStruct->EUART_BaudRate) - 1;
        }
        else
        {
            BaudTemp = SystemCoreClock / 32 / EUART_InitStruct->EUART_BaudRate;
        }
    }
    else if (EUART_InitStruct->EUART_ClockSet == EUART_Clock_3)
    {
        BaudClockTemp = (SystemCoreClock / 64) % EUART_InitStruct->EUART_BaudRate;

        if (EUART_InitStruct->EUART_BaudRate >= (2 * BaudClockTemp))
        {
            BaudTemp = (SystemCoreClock / 64 / EUART_InitStruct->EUART_BaudRate) - 1;
        }
        else
        {
            BaudTemp = SystemCoreClock / 64 / EUART_InitStruct->EUART_BaudRate;
        }
    }

    if (BaudTemp > 2046)
    {
        BaudTemp = 2047;
    }

    EUARTx->CON.BCS = EUART_InitStruct->EUART_ClockSet;
    EUARTx->BRR.BRR = BaudTemp;
    EUARTx->CON.TXFS   =  EUART_InitStruct->EUART_StopBits;
    EUARTx->CON.TXMOD  =  EUART_InitStruct->EUART_TxMode;
    EUARTx->CON.TXP    =  EUART_InitStruct->EUART_TxPolar;
    EUARTx->CON.RXMOD  =  EUART_InitStruct->EUART_RxMode;
    EUARTx->CON.RXP    =  EUART_InitStruct->EUART_RxPolar;
}

/***************************************************************
EUART_BaudConfig
  EUART
ֵEUARTxEUART0  BaudRateĿ겨ʣHZ  ClockSetʷʱѡ
ֵ
ֵ
***************************************************************/
void EUART_BaudConfig(EUART_TypeDef *EUARTx, uint32_t BaudRate, EUART_TYPE_BCS ClockSet)
{
    uint32_t BaudTemp = 0, BaudClockTemp = 0;

    if (BaudRate == 0)
        return;
		
    if (ClockSet == EUART_Clock_1)
    {
				BaudClockTemp = (SystemCoreClock / 16) % BaudRate;
        if (BaudRate >= (2 * BaudClockTemp))
        {
            BaudTemp = (SystemCoreClock / 16 / BaudRate) - 1;
        }
        else
        {
            BaudTemp = SystemCoreClock / 16 / BaudRate;
        }
    }
    else if (ClockSet == EUART_Clock_2)
    {
				BaudClockTemp = (SystemCoreClock / 32) % BaudRate;
        if (BaudRate >= (2 * BaudClockTemp))
        {
            BaudTemp = (SystemCoreClock / 32 / BaudRate) - 1;
        }
        else
        {
            BaudTemp = SystemCoreClock / 32 / BaudRate;
        }
    }
    else if (ClockSet == EUART_Clock_3)
    {
				BaudClockTemp = (SystemCoreClock / 64) % BaudRate;
        if (BaudRate >= (2 * BaudClockTemp))
        {
            BaudTemp = (SystemCoreClock / 64 / BaudRate) - 1;
        }
        else
        {
            BaudTemp = SystemCoreClock / 64 / BaudRate;
        }
    }

    if (BaudTemp > 2046)
    {
        BaudTemp = 2047;
    }

    EUARTx->CON.BCS = ClockSet;
    EUARTx->BRR.BRR = BaudTemp;
}

/***************************************************************
EUART_ITConfig
  EUARTж
ֵEUARTxEUART0  EUART_ITж  NewStateʹ/ʧ
ֵ
ֵ
***************************************************************/
void EUART_ITConfig(EUART_TypeDef *EUARTx, EUART_TYPE_IT EUART_IT, TYPE_FUNCEN NewState)
{
    if (NewState != DISABLE)
    {
        EUARTx->IE.Word |= (uint32_t) EUART_IT;
    }
    else
    {
        EUARTx->IE.Word &=  ~((uint32_t) EUART_IT);
    }
}

/***************************************************************
EUART_TBIMConfig
  EUARTͻжģʽѡ
ֵEUARTxEUART0  Typeжģʽ
ֵ
ֵ
***************************************************************/
void EUART_TBIMConfig(EUART_TypeDef *EUARTx, EUART_TYPE_TRBIM Type)
{
    EUARTx->IE.TBIM = Type;
}

/***************************************************************
EUART_RBIMConfig
  EUARTջжģʽѡ
ֵEUARTxEUART0  Typeжģʽ
ֵ
ֵ
***************************************************************/
void EUART_RBIMConfig(EUART_TypeDef *EUARTx, EUART_TYPE_TRBIM Type)
{
    EUARTx->IE.RBIM = Type;
}

/***************************************************************
EUART_GetFlagStatus
  EUARTȡ־λ״̬
ֵEUARTxEUART0  EUART_Flag־λ
ֵ
ֵSET/RESET
***************************************************************/
FlagStatus EUART_GetFlagStatus(EUART_TypeDef *EUARTx, EUART_TYPE_FLAG EUART_Flag)
{
    FlagStatus bitstatus = RESET;

    if ((EUARTx->IF.Word & ((uint32_t)EUART_Flag)) != RESET)
    {
        bitstatus = SET;
    }
    else
    {
        bitstatus = RESET;
    }

    return  bitstatus;
}

/***************************************************************
EUART_GetITStatus
  EUARTȡж״̬,δʹӦжʱ᷵SET
ֵEUARTxEUART0  EUART_Flag־λ
ֵ
ֵSET/RESET
***************************************************************/
ITStatus EUART_GetITStatus(EUART_TypeDef *EUARTx, EUART_TYPE_IT EUART_Flag)
{
    FlagStatus bitstatus = RESET;
    uint32_t itstatus = 0x0, itenable = 0x0;

    itenable = EUARTx->IE.Word & (uint32_t)EUART_Flag;
    itstatus = EUARTx->IF.Word & (uint32_t)EUART_Flag;

    if ((itstatus != (uint32_t)RESET) && (itenable != (uint32_t)RESET))
    {
        bitstatus = SET;
    }
    else
    {
        bitstatus = RESET;
    }

    return  bitstatus;
}

/***************************************************************
EUART_ClearITPendingBit
  EUART־λ
ֵEUARTxEUART0  EUART_Flag־λ
ֵ
ֵ
***************************************************************/
void EUART_ClearITPendingBit(EUART_TypeDef *EUARTx, EUART_CLR_IF EUART_Flag)
{
    EUARTx->IF.Word = (uint32_t)EUART_Flag;
}


/*------------------------------------------------------------------------------------------------*/
/********************************U7816ܿģغ*******************************************/
/*------------------------------------------------------------------------------------------------*/

/***************************************************************
U7816_Init
  ʼU7816ģ
ֵEUARTxEUART0  U7816_InitStructʼýṹַ
ֵ
ֵ
***************************************************************/
void  U7816_Init(EUART_TypeDef *EUARTx, U7816_InitStruType *U7816_InitStruct)
{
    EUARTx->MOD.CK0E =  U7816_InitStruct->U7816_ECK0;        // EUARTxMODbit2   7816ECK0ʹλ

    EUARTx->MOD.CK1E =  U7816_InitStruct->U7816_ECK1;        // EUARTxMODbit3   7816ECK1ʹλ

    EUARTx->MOD.CHS  =  U7816_InitStruct->U7816_EIOCh;       // EUARTxMODbit4   EIOͨѶͨѡλ

    EUARTx->MOD.IOC  =  U7816_InitStruct->U7816_EIODir;      // EUARTxMODbit5   EIO˿ڷ

    EUARTx->MOD.DAS  =  U7816_InitStruct->U7816_DataForm;    // EUARTxMODbit6   ݸʽѡλ

    EUARTx->MOD.PS   =  U7816_InitStruct->U7816_DataVerify;  // EUARTxMODbit7   żУλ

    EUARTx->MOD.ARTE =  U7816_InitStruct->U7816_AutoRetryTX; // EUARTxMODbit8   Զطʹλ

    EUARTx->MOD.ARRE =  U7816_InitStruct->U7816_AutoRetryRX; // EUARTxMODbit9   Զʹλ

    EUARTx->MOD.TNAS =  U7816_InitStruct->U7816_NACK_Width;  // EUARTxMODbit11~10  NACKźſ

    EUARTx->MOD.ARTS =  U7816_InitStruct->U7816_RetryTimes;  // EUARTxMODbit12~13  Զط

    EUARTx->MOD.CKS  =  U7816_InitStruct->U7816_CLKS;        // EUARTxMODbit15~14  ʱԴѡ

    //ò
    EUART_BaudConfig(EUARTx, U7816_InitStruct->U7816_BaudRate, U7816_InitStruct->U7816_ClockSet);

    /* EUARTxMODbit23~16  ETUʱѡ 2~257 ETU */
    if (U7816_InitStruct->U7816_ETUTime > 255)
    {
        U7816_InitStruct->U7816_ETUTime = 255;
    }

    EUARTx->MOD.ETUS  =  U7816_InitStruct->U7816_ETUTime;

}

/***************************************************************
EUART_EIOChConfig
  EUART EIO ͨѶͨѡ
ֵEUARTxEUART0  U7816_IOIO˿ں
ֵ
ֵ
***************************************************************/
void  EUART_EIOChConfig(EUART_TypeDef *EUARTx, U7816_TYPE_CHS U7816_IO)
{
    EUARTx->MOD.CHS  =  U7816_IO;
}

/***************************************************************
EUART_EIODirection
  EUART EIO ˿ڷ
ֵEUARTxEUART0  directionIO˿״̬
ֵ
ֵ
***************************************************************/
void EUART_EIODirection(EUART_TypeDef *EUARTx, U7816_TYPE_EIOC Dir)
{
    EUARTx->MOD.IOC  =  Dir;
}

/***************************************************************
EUART_SendByte
  EUART Byteд
ֵEUARTxEUART0  ByteDataд
ֵ
ֵ
***************************************************************/
void EUART_SendByte(EUART_TypeDef *EUARTx, uint8_t ByteData)
{
    EUARTx->TBW.Byte[0] = ByteData;
}

/***************************************************************
EUART_SendHalfWord
  EUART HalfWordд
ֵEUARTxEUART0  HalfWordDataд
ֵ
ֵ
***************************************************************/
void EUART_SendHalfWord(EUART_TypeDef *EUARTx, uint16_t HalfWordData)
{
    EUARTx->TBW.HalfWord[0] = HalfWordData;
}

/***************************************************************
EUART_SendWord
  EUART wordд
ֵEUARTxEUART0  WordDataд
ֵ
ֵ
***************************************************************/
void EUART_SendWord(EUART_TypeDef *EUARTx, uint32_t WordData)
{
    EUARTx->TBW.Word = WordData;
}

/***************************************************************
EUART_RecByte
  EUART Byte
ֵEUARTxEUART0
ֵ
ֵ
***************************************************************/
uint8_t EUART_RecByte(EUART_TypeDef *EUARTx)
{
    return (EUARTx->RBR.Byte[0]);
}

/***************************************************************
EUART_RecHalfWord
  EUART HalfWord
ֵEUARTxEUART0
ֵ
ֵ
***************************************************************/
uint16_t EUART_RecHalfWord(EUART_TypeDef *EUARTx)
{
    return (EUARTx->RBR.HalfWord[0]);
}

/***************************************************************
EUART_RecWord
  EUART Word
ֵEUARTxEUART0
ֵ
ֵ
***************************************************************/
uint32_t EUART_RecWord(EUART_TypeDef *EUARTx)
{
    return (EUARTx->RBR.Word);
}

/*************************END OF FILE**********************/
