/*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ lib_lcd.h
* ߣ JiangYz
*  V1.00
* ڣ 2016/02/02
*  LCDģ⺯ͷļ
* ע  HR8P287оƬ
 ѧϰʾʹãûֱôķջеκηΡ
***************************************************************/

#ifndef __LIBLCDC_H__
#define __LIBLCDC_H__


#include "HR8P287.h"

#include "type.h"

/*SEG˿ڶ*/
typedef enum
{
    Sel_0 = 0x0 ,  //ѡLCDSEL0
    Sel_1 = 0x1 ,  //ѡLCDSEL1
	  Sel_All=0x2,  //ѡLCDSEL0+LCDSEL1
}LCDSEL_TYPE;

/* жʹ */
typedef enum
{
    LCD_IE_OFF = 0x1 , //LCDرжʹλ
    LCD_IE_RF = 0x2 ,  //LCDؼĴˢжʹλ 
 
}LCD_TYPE_IE;

/* LCDCOMSѡ */
typedef enum
{
		LCD_Coms_1 = 0,	/*  */
		LCD_Coms_2 = 4,	/* COM1~COM0*/
		LCD_Coms_3 = 6,	/* COM2~COM0*/
		LCD_Coms_4 = 1,	/* COM3~COM0*/
		LCD_Coms_6 = 2,	/* COM5~COM0*/
		LCD_Coms_8 = 3,	/* COM7~COM0*/
}LCD_TYPE_COMS;

/* LCDѡλ */ 
typedef enum
{
    LCD_WaveMode_A = 0x0 , // AͲ
    LCD_WaveMode_B = 0x1 , // BͲ
}LCD_TYPE_WFS;

/* LCDƫѡ */ 
typedef enum
{
    LCD_Bias_3 = 0x0 ,      // 1/3ƫ
    LCD_Bias_4 = 0x3 ,      // 1/4ƫ
}LCD_TYPE_BIAS;

/* LCDڲƫõѡ */
typedef enum
{
    LCD_Res_15k = 0x0 ,  // ƫѹ15k
    LCD_Res_50k = 0x1 ,  // ƫѹ50k
    LCD_Res_100k = 0x2 , // ƫѹ100k
    LCD_Res_200k = 0x3 , // ƫѹ200k
}LCD_TYPE_LCDRS; 

/* LCDʾҶȿ */ 
typedef enum
{
	LCD_Grayscale_VLCD = 0x0 , // Vbias = VLCD
	LCD_Grayscale_35_36_VLCD = 0x1 , // Vbias = (35/36)VLCD
	LCD_Grayscale_34_36_VLCD = 0x2 , // Vbias = (34/36)VLCD
	LCD_Grayscale_32_36_VLCD = 0x3 , // Vbias = (32/36)VLCD
	LCD_Grayscale_31_36_VLCD = 0x4 , // Vbias = (31/36)VLCD
	LCD_Grayscale_30_36_VLCD = 0x5 , // Vbias = (30/36)VLCD
	LCD_Grayscale_29_36_VLCD = 0x6 , // Vbias = (29/36)VLCD
	LCD_Grayscale_28_36_VLCD = 0x7 , // Vbias = (28/36)VLCD
}LCD_TYPE_BVS;
/*LCD ڲƫѡλ*/
typedef enum
{
	LCD_BiasSel_0 =0x0,   //ƫʹλΪ0 
	LCD_BiasSel_1 =0x1,   //ƫʹλΪ1
}LCD_TYPE_BIAS_SEL;

/* LCDؼĴֽѡ */ 
typedef enum
{
    LCD_Byte_0 = 0x0 , 
    LCD_Byte_1 = 0x1 , 
    LCD_Byte_2 = 0x2 , 
    LCD_Byte_3 = 0x3 , 
}LCD_DD_BYTE; 

/* LCDؼĴѡ */ 
typedef enum
{
    LCD_HalfWord_0 = 0x0 ,   //Ͱ
    LCD_HalfWord_1 = 0x1 ,   //߰
}LCD_DD_HALFWORD; 

/* LCD ؼĴѡ*/
typedef enum
{
	LCD_Pixel_LCDD0 = 0x0 , /* ؼĴ0 */
	LCD_Pixel_LCDD1 = 0x1 , /* ؼĴ1 */
	LCD_Pixel_LCDD2 = 0x2 , /* ؼĴ2 */
	LCD_Pixel_LCDD3 = 0x3 , /* ؼĴ3 */
	LCD_Pixel_LCDD4 = 0x4 , /* ؼĴ4 */
	LCD_Pixel_LCDD5 = 0x5 , /* ؼĴ5 */
	LCD_Pixel_LCDD6 = 0x6 , /* ؼĴ6 */
	LCD_Pixel_LCDD7 = 0x7 , /* ؼĴ7 */
	LCD_Pixel_LCDD8 = 0x8 , /* ؼĴ8 */
	LCD_Pixel_LCDD9 = 0x9 , /* ؼĴ9 */
	LCD_Pixel_LCDD10 = 0xA , /* ؼĴ10 */
	LCD_Pixel_LCDD11 = 0xB , /* ؼĴ11 */
}LCD_TYPE_PIXEL;

typedef struct
{
    LCD_TYPE_COMS  LCD_Coms;           // LCDCON0:bit2~0 ѡλ 
	  TYPE_FUNCEN  LCD_LcdFlik;         // LCDCON0:bit5 LCDʾ˸ʹλ  
	  LCD_TYPE_WFS  LCD_LcdWFS;        // LCDCON0:bit6 LCDѡλ
	  LCD_TYPE_BIAS  LCD_Bias;        // LCDCON0:bit9~8 LCDƫѡ
    LCD_TYPE_LCDRS  LCD_RS;        // LCDCON0:bit11~10 LCDڲƫõѡ
    LCD_TYPE_BVS  LCD_Grayscale;  // LCDCON0:bit14~12 LCDʾҶȿ  
	  LCD_TYPE_BIAS_SEL LCD_BIAS_SEL;      // LCDCON0:bit3 ڲƫõѹʹλ
	  uint8_t  LCD_PRS;           // LCDʱԴƵѡλ 0~63
	uint32_t  LCD_SEG0;          // LCDSEL0bbit31~0 LCDʹ
	uint32_t  LCD_SEG1:16;       // LCDSEL1bbit15~0 LCDʹ
}LCD_InitStruType;

/************LCDģ궨************/

/* LCDʹܿ */
#define LCD_Enable()  (LCDC->CON1.EN= 0x1)
#define LCD_Disable() (LCDC->CON1.EN= 0x0)

/* LCDʾ˸ʹܿ */
#define LCD_FLIK_Enable()  (LCDC->CON0.FLIK = 0x1)
#define LCD_FLIK_Disable() (LCDC->CON0.FLIK = 0x0)

/* ؼĴˢ */
#define LCD_SetRFREQ()   (LCDC->CON1.RFREQ = 0x1)
#define LCD_ClearRFREQ() (LCDC->CON1.RFREQ = 0x0)

/* LCDرжϱ־ */
#define LCD_ClearOFFIF() ( LCDC->IF.OFFIF = 0x1)

/* LCDؼĴˢжϱ־ */
#define LCD_ClearRFIF() (LCDC->IF.RFIF = 0x1)

/* LCDλ */
#define LCD_Rest() (LCDC->CON1.RST = 0x01)

/************LCDģ麯***********/
ErrorStatus LCD_Init(LCD_InitStruType * LCD_InitStruct,LCDSEL_TYPE SELx);
void LCD_ITConfig(LCD_TYPE_IE LCD_IT,TYPE_FUNCEN NewState);
ITStatus LCD_GetRFITStatus(void);
ITStatus LCD_GetOFFITStatus(void);
void LCD_GrayscaleConfig(LCD_TYPE_BVS LCD_Grayscale );
ErrorStatus LCD_FlickerTimeConfig(uint8_t On_Time,uint8_t Off_Time);
ErrorStatus  LCD_PixelWriteByte(LCD_TYPE_PIXEL LCD_DD, LCD_DD_BYTE nByte ,uint8_t LCD_data);
ErrorStatus  LCD_PixelWriteHalfWord(LCD_TYPE_PIXEL LCD_DD, LCD_DD_HALFWORD nHalfWord , uint16_t LCD_data);
ErrorStatus  LCD_PixelWriteWord(LCD_TYPE_PIXEL LCD_DD,uint32_t LCD_data);


#endif



/*************************END OF FILE**********************/
