/***************************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ lib_flashiap.h
* ߣ WangBJ
*  V1.00
* ڣ 2014/10/24
*  flashд⺯ͷļ
* ע  HR8P287оƬ
 ѧϰʾʹãûֱôķջеκηΡ
***************************************************************/

#ifndef __LIBIAP_H__
#define __LIBIAP_H__

#include "HR8P287.h"
#include "type.h"

/* IAP״̬λ */
typedef enum
{
	IAP_FLAG_BSY = 0x0001 ,
	IAP_FLAG_ERASE_END = 0x0002 ,
	IAP_FLAG_PROG_END = 0x0004 ,
	IAP_FLAG_TIMEOUT_ERR = 0x0008 ,
}IAP_STA_FLAG;

/*************IAPģ궨************/

/* Ĵ */
#define FlashIAP_RegUnLock() (IAP->UL.IAPUL = 0x000000A5)
#define FlashIAP_RegLock()   (IAP->UL.IAPUL = 0x0)

/* ʹIAP */
#define FlashIAP_Enable()  (IAP->CON.EN = 0x1)
#define FlashIAP_Disable() (IAP->CON.EN = 0x0)

/* IAP */
#define FlashIAP_REQ() (IAP->CON.FLASH_REQ = 0x1)

/************Flashģ麯***********/
ErrorStatus FlashIap_Unlock(void);
ErrorStatus FlashIap_WriteEnd(void);
ErrorStatus FlashIap_ErasePage(uint8_t Page_Addr);
ErrorStatus FlashIap_WriteCont(uint8_t Unit_addr, uint8_t Page_addr, uint32_t Data32);
ErrorStatus FlashIap_WriteWord(uint8_t Unit_addr, uint8_t Page_addr, uint32_t Data32);
ErrorStatus Flash_Read(uint32_t * Ram_Addr, uint32_t Flash_Addr, uint8_t Len);

#endif

/*************************END OF FILE**********************/
