/***************************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ  lib_timer.h
*  ߣ  ZouX
*    V1.00
*  ڣ  2016/01/31
*    ADCģ⺯ͷļ
*  ע   HR8P287оƬ
           ѧϰʾʹãûֱôķջеκηΡ
***************************************************************/

#ifndef __LIBADC_H__
#define __LIBADC_H__

#include "HR8P287.h"
#include "type.h"

/* ADCʱԴѡ */
typedef enum
{
    ADC_ClkS_Pclk = 0x0 ,  //ʱӣPCLK
    ADC_ClkS_32Khz = 0x1 , //ʱӣADCCLK(32KHZ)
}ADC_TYPE_CLKS;

/* ADCʱԴԤƵ */
typedef enum
{
    ADC_ClkDiv_1 = 0x0 ,   //ԤƵ1:1
    ADC_ClkDiv_2 = 0x1 ,   //ԤƵ1:2
    ADC_ClkDiv_4 = 0x2 ,   //ԤƵ1:4
    ADC_ClkDiv_8 = 0x3 ,   //ԤƵ1:8
    ADC_ClkDiv_16 = 0x4 ,  //ԤƵ1:16
    ADC_ClkDiv_32 = 0x5 ,  //ԤƵ1:32
    ADC_ClkDiv_64 = 0x6 ,  //ԤƵ1:64
    ADC_ClkDiv_256 = 0x7 , //ԤƵ1:256
}ADC_TYPE_CLKDIV;

/* ADC뷽ʽ */
typedef enum
{
    ADC_Align_Right = 0x1 , //룺Ҷ루Ͷ룩
    ADC_Align_Left = 0x0 ,  //룺루߶룩
}ADC_TYPE_FM;

/* οѹѡ */
typedef enum
{
    ADC_VrefP_Vcc = 0x0 ,    //οѹ3.3V LDOѹ
    ADC_VrefP_Ref = 0x1 ,    //οѹڲοѹVref 2.048V AVREFP˿ڸΪͨIO
	  ADC_VrefP_Ref2 = 0x2 ,    //οѹڲοѹVref 2.048V AVREFP˿VREF
    ADC_VrefP_Exter = 0x3 ,  //οѹⲿοѹ
}ADC_TYPE_VREFP;

/* ģʽѡ */
typedef enum
{
    ADC_Samp_Soft = 0x0 ,     //ADģʽѡ
    ADC_Samp_Hardware = 0x1 , //ADģʽѡӲ
}ADC_TYPE_SMPS;

/* ADCʱѡ */
typedef enum
{
    ADC_SampClk_2 = 0x0 ,  //ADʱѡ2TadClk
    ADC_SampClk_4 = 0x1 ,  //ADʱѡ4TadClk
    ADC_SampClk_8 = 0x2 ,  //ADʱѡ8TadClk
    ADC_SampClk_16 = 0x3 , //ADʱѡ16TadClk
}ADC_TYPE_ST;
 
/* ADCͨѡ */
typedef enum
{
    ADC_Ch_0 = 0x0 ,       //ͨ0
    ADC_Ch_1 = 0x1 ,       //ͨ1
    ADC_Ch_2 = 0x2 ,       //ͨ2
    ADC_Ch_3 = 0x3 ,       //ͨ3
    ADC_Ch_4 = 0x4 ,       //ͨ4
    ADC_Ch_5 = 0x5 ,       //ͨ5
    ADC_Ch_6 = 0x6 ,       //ͨ6
    ADC_Ch_7 = 0x7 ,       //ͨ7
    ADC_Ch_8 = 0x8 ,       //ͨ8
    ADC_Ch_9 = 0x9 ,       //ͨ9
    ADC_Ch_10 = 0xa ,       //ͨ10
}ADC_TYPE_CHS;

/*ADC buffѡλ*/
typedef enum
{
	ADC_BUFF_0ua = 0,     //ADC buffΪ0uAƼʹ
	ADC_BUFF_34ua = 1,    //ADC buffΪ34uA
	ADC_BUFF_95ua = 2,     //ADC buffΪ95uA
}ADC_TYPE_BUFEN;

/* ADCʼýṹ嶨 */
typedef struct
{
    ADC_TYPE_CLKS  ADC_ClkS;      //ADCCON1:bit3 ADCʱԴѡ 

    ADC_TYPE_CLKDIV  ADC_ClkDiv;  //ADCCON1:bit2-0 ADCʱԴԤƵ 

    ADC_TYPE_FM  ADC_Align;       //ADCCON1:bit6 ADC뷽ʽ 

    ADC_TYPE_VREFP  ADC_VrefP;    //ADCCON1:bit9-8 ADCοѹѡ

    ADC_TYPE_SMPS  ADC_SampS;     //ADCCON1:bit12 ADCģʽѡ

    ADC_TYPE_ST  ADC_SampClk;     //ADCCON1:bit15-14 ADCʱѡ

    ADC_TYPE_CHS  ADC_ChS;        //ADCCHS:bit0-3 ADCģͨѡ
	
	  ADC_TYPE_BUFEN ADC_Buf;       //ADC_BUF_EN    ADCbufferѡ

}ADC_InitStruType;



/************ADCģ궨***********/

/* ADCʹܿ */
#define ADC_Enable()  (ADC->CON0.EN = 0x1)
#define ADC_Disable() (ADC->CON0.EN = 0x0)

/* ADCʼת */
#define ADC_Start() (ADC->CON0.TRG = 0x1)

/* ADC */
#define ADC_SampStart() (ADC->CON1.SMPON = 0x1)
#define ADC_SampStop()  (ADC->CON1.SMPON = 0x0)

/* жϱ־ */
#define ADC_ClearITPendingBit() (ADC->IF.IF = 0x1)

/* ADCжʹܿ */
#define ADC_IT_Enable()  (ADC->IE.IE = 0x1)
#define ADC_IT_Disable() (ADC->IE.IE = 0x0)
 
/************ADCģ麯***********/
void ADC_Init(ADC_InitStruType * ADC_InitStruct);
void ADC_Set_CH(ADC_TYPE_CHS AdcCH);
uint16_t ADC_GetConvValue(void);
FlagStatus ADC_GetConvStatus(void);
FlagStatus ADC_GetFlagStatus(void);
ITStatus ADC_GetITStatus(void);
void ADC_Reset(void);
#endif

/*************************END OF FILE**********************/
