/***************************************************************
 *Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd
 *ļ  system_HR8P287.h
 *  ߣ  Zoux
 *    V1.00
 *  ڣ
 *    ⺯ļ
 *  ע   HR8P287оƬ
 ѧϰʾʹãûֱôķջеκηΡ
 ***************************************************************/

#ifndef __SYSTEMHR8P287_H__
#define __SYSTEMHR8P287_H__

#include "HR8P287.h"
#include "system_HR8P287.h"


uint32_t SystemCoreClock   = 16000000;

/***************************************************************
  SystemCoreClockUpdate
    ϵͳʱΪڲʱ16MHZͬʱSystemCoreClock
  ֵ
  ֵ
  ֵ
 ***************************************************************/
void SystemCoreClockUpdate(void)
{
    uint32_t Prot_Temp;
    uint16_t Count = 0;

    Prot_Temp = SCU->PROT.PROT;

    if (Prot_Temp != 0)  //д
    {
        SCU->PROT.Word = 0x55AA6996;   //*/
    }

    SCU->SCLKEN0.HRC_EN = 1;                      //ʹڲ16MHZ

    do
    {
        Count++;
    }
    while ((SCU->SCLKEN0.HRC_ON == 0) && (Count != 0xFFF)); //ȴʱӿ

    if (Count == 0xFFF)
    {
        return ;
    }

    SCU->SCLKEN0.SYSCLK_SSE = 0;    //ѡڲ16MHZΪϵͳʱ
    Count = 0;

    do
    {
        Count++;
    }
    while ((SCU->SCLKEN0.SYSCLK_CHG != 0) && (Count != 0xFFF)); //ȴл

    if (Count == 0xFFF)
    {
        return ;
    }

    SCU->SCLKEN0.SYSCLK_DIV = 0;          //ϵͳʱӺƵ1:1
    //SCU->SCLKEN0.SYSCLKOE = 1;            //ϵͳʱ128ƵʹܿͨSYSCLK0


    switch (SCU->SCLKEN0.SYSCLK_SST)
    {
        case 0:
            SystemCoreClock = 16000000;   //HRC
            break;

        case 1:
            SystemCoreClock = 32000;      //LRC
            break;

        default:
            break;
    }

    if (Prot_Temp != 0)  //д
    {
        SCU->PROT.Word = 0x00000000;   //д
    }
}



/***************************************************************
  SystemInit
    ϵͳʼʱ
  ֵ
  ֵ
  ֵ
 ***************************************************************/
void SystemInit(void)
{
    SystemCoreClockUpdate();
	
		GPIO->PCDIR.Word = 0x00000000;          //PC̶Ϊ
		GPIO->PCS.Word = 0xFFFFFFFF;            //PC̶ߵƽ
}


#endif

/*************************END OF FILE**********************/
