/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	uart.c
*  :	XieYF
*  :	V1.70
*  :	2014/11/25
*  :	ͨ첽շ
*  ע:    HR7P193/194/293
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include	<hic.h>
#define	UART_TX_TRIS	PBT4
#define	UART_RX_TRIS	PBT5

//----------------------
volatile unsigned char twoSecondCounter = 0;		//2sʱ; T8P1Ϊ20msʱʱ
volatile unsigned char uartTxCount = 0;				//UARTֽ
volatile unsigned char uartRxCount = 0;				//UARTֽ
volatile unsigned char uartRxData[4] = {0,0,0,0};	//UARTջ
unsigned char uartTxData[4] = { 0x55,0xAA,0x5A,0xA5 };//UARTͻ



/*==================================================================
RAM
==================================================================*/
void ram_clear(void)
{
	BKSR = (BKSR&0X0f)|0X00;  //bank0
	for(IAA=0x020;IAA<=0x7f;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X00; //bank1
	for(IAA=0x0a0;IAA<=0xef;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X10;   //bank2
	for(IAA=0x20;IAA<=0x6f;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X20;  //bank4
	for(IAA=0x20;IAA<=0x6f;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X20;   //bank5
	for(IAA=0xa0;IAA<=0xef;IAA++)
	{
		IAD = 0X00;
	}
	BKSR = (BKSR&0X0f)|0X30;  //bank6
	for(IAA=0x20;IAA<=0x6f;IAA++)
	{
		IAD = 0X00;
	}
	
}
/*==================================================================
жϷ
1UART RXжϣһݰΪ4ֽڣͨT8NļжǷΪݰͷֽڣԷݽմλ⣻T8N10msսյϸ֮ʱ10msΪսյһݰĵһֽڣ
2UART TXжϣֻҪжϵһݰ4ֽڣرTXжϣ
3T8P1ʱ20msжϣжϵʱ2sUART TXжϣʼһ4ֽݣ 
==================================================================*/
void isr(void) interrupt
{
	if ( RXIE && RXIF )
	{   								//UARTж
		uartRxData[uartRxCount] = RXB;	//յݻ
		uartRxCount++;					//ջַһ
		T8N = 0;
		if(uartRxCount == 4)
		{								//4ֽ
			uartRxCount = 0;			//ջַ
			if( uartRxData[0]==0x55 && uartRxData[1]==0xAA && \
			uartRxData[2]==0x5A && uartRxData[3]==0xA5 )
			{
				PC5	^= 1;				//ȷPC5˿ȡ
			}
			uartRxData[0] = 0;			//ݻ
			uartRxData[1] = 0;
			uartRxData[2] = 0;
			uartRxData[3] = 0;
		} 
	}
	if ( TXIE && TXIF ) 
	{ 									//UARTж
		TXB	= uartTxData[uartTxCount];	//ѷͻǰַݷ뷢ͼĴ
		uartTxCount++;					//ͻַһ
		if(uartTxCount == 4)
		{
			TXIE = 0;					//4ֽں󣬹رUARTж
			uartTxCount = 0;			//㷢ͻַ
		}
	}
	if (T8P1IE && T8P1IF) 
	{									//T8P1ʱж
		T8P1IF = 0;
		twoSecondCounter++;
		if(twoSecondCounter == 100 )
		{
			twoSecondCounter= 0;		//2sʱʱ䵽UARTķж
			uartTxCount	= 0;			//㷢ͻַ
			TXIE = 1;					//ʹUARTжϣ뷢жϷ
		}
	}
}
/*==================================================================

==================================================================*/
void main(void)
{
	ram_clear();
	//----------ϵͳʱӳʼ------------
	OSCC = 0x50;		//ϵͳʱΪڲ4MHz
	//--------------I/Oʼ----------------
	ANSEL = 0xFF;		//AN0~AN7˿Ϊֿ
	ADCC1 = 0xFF;     	//AN8~AN9˿Ϊֿ
	PCT5 = 0;			//PC5˿Ϊ
	//-------------T8P1ʼ--------------
	T8P1P = 249;		//T8P1PڼĴֵ
	T8P1C = 0x27;		//T8P1ԤƵ1:16,ͺƵ1:5,T8P1
	//--------------T8Nʼ--------------
	BSET = 0x87;     	//ԤƵT8NƵ1:256
	T8N	= 0;			//T8NĴֵ
	//-------------UARTʼ--------------
	UART_TX_TRIS = 0;	//UART TX˿Ϊ
	UART_RX_TRIS = 1;	//UART RX˿Ϊ
	TXM	= 0;			//UARTģʽΪ8λݸʽ
	BRGH = 1;			//UARTΪģʽ
	BRR	= 207;			//UARTΪ1200bps
	RXEN = 1;			//ʹUART
	TXEN = 1;			//ʹUART
	//----------------жʹ----------------
	T8P1IF = 0;			//T8P1ʱжϱ־
	T8P1IE = 1;			//ʹT8P1ʱж
	TXIE = 0;			//ֹUARTж
	RXIE = 1;			//ʹUARTж
	INTC1 = 0x00;		//Ĭжģʽжڵַ0x004
	INTC0 = 0xC0;		//ʹΧģжϺȫж
	while(1)
	{
		if(T8N > 39)
		{
			/*==================================================================
			յһ֮ʱ40256=10msΪǴһݵĵһֽڣռ㣬ͬʱֽڽ֮ļʱT8N
			==================================================================*/
			uartRxCount	= 0;
			T8N		= 0;
		}
	}
}