/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  iic_slave.c
*  :  WangYQ
*  :  v1.0iDesigner(v4.2.3.159) + HRCC(v1.2.0.102)
*  :  2018/08/07
*  :  I2Cӻģʽʾ
          PB1SCL
          PB0SDA
          1ʹI2Cģ64ֽڵEEPROM֧д
          2дݣд+Ƭʼַ+nֽ
             磺W[2D] 0x0 1 2 3 4 5
          3ݣд+Ƭʼַ+n
             磺W[2D] 0x0 R[2D] R[2D] R[2D] R[2D] R[2D]
          4ʼַΧ0-63ʼַ+nܴ64
*  ע:  ES7P1391оƬ̽ο
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ
#define SLAVE_ADDR 0x2D

typedef unsigned char uchar;
typedef unsigned int uint;

uchar e2prom_data[64];
uchar e2prom_addr,buf8;
uchar i2c_sta = 0;

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH=0; IAAH<=0x03; IAAH++)
    {
        for (IAAL=0; IAAL<0xFF; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
    PBT0 = 1;       //SDA˿Ϊ
    PBT1 = 1;       //SCK˿Ϊ
}

/**********************************************
void isr(void) interrupt 
  жϺ
ֵ
ֵ
ֵ
**********************************************/
void isr(void) interrupt
{
    if(I2CIE==1 && I2CIF==1)
    {
        if(I2CRBIE==1 && I2CRBIF==1)    //ж
        {
            if(i2c_sta == 0)
            {
                e2prom_addr = I2CRB;    //ȡַ
                I2CTB = e2prom_data[e2prom_addr];       //ݷŵͻ
            }
            else e2prom_data[e2prom_addr++] = I2CRB;    //ȡ
            i2c_sta++;
        }

        if(I2CSRIE==1 && I2CSRIF==1)    //յʼλ+ַƥ+Ӧλ
        {
            I2CSRIF = 0;            //ʼλ+ַƥ+Ӧλж
            i2c_sta = 0;            //ձ־λ
            if(I2CRW == 1)      //
            {
                I2CRBIE = 0;
                I2CTBIE = 1;
            }
            else                //д
            {
                I2CRBIE = 1;
                I2CTBIE = 0;
            }
        }
        if(I2CTBIE==1 && I2CTBIF==1)
        {
            I2CTB = e2prom_data[++e2prom_addr];     //һݷŵͻ
        }
        if(I2CSPIE==1 && I2CSPIF==1)    //ֹͣλж
        {
            I2CSPIF = 0;
            I2CRST = 1;         //λI2C
            while(I2CRST);      //ȴλ
            I2CC = 0xE1;
            I2CIEC = 0x43;

        }
        if(I2CNAIE==1 && I2CNAIF==1)    //NACKж
        {
            I2CNAIF = 0;
        }
    }
    I2CIF = 0;
}

/**********************************************
main() 
  
ֵ
ֵ
ֵ
**********************************************/
void main() 
{
    uint i;
    RAMclear();
    GPIOInit();
    I2CRST = 1;         //λI2C
    while(I2CRST);      //ȴλ
    I2CC = 0xE0;        //I2C©ACK
    I2CSA = SLAVE_ADDR<<1;      //ӻַ
    I2CEN = 1;          //ʹI2C
    I2CIEC = 0x43;      //ʹַܵƥжϣNACKжϣֹͣλж
    I2CIE = 1;          //ʹI2Cж
    I2CIFC = 0x00;      //־λ
    GIE = 1;        //ж
    for(i = 0;i<64;i++)
        e2prom_data[i] = 0; //սջ
    while(1)
    {
        CLRWDT();
    }
}
