/*******************************************************
*Copytight(C),2017,Shanghai Eastsoft Microelectronics Co.,Ltd.
*ļiap_flash.c
*  ߣwangyq
*  v1.1iDesigner(v4.2.3.159) + HRCC(v1.2.0.102)
*  ڣ2018/8/8
*  IAPʹFRENַ0x0000~0x1EFF0x0000~0x00FFΪ1ҳ
         0x0100~0x01FFΪ2ҳ0x0200~0x02FFΪ3ҳԴơ
         IAPҳ(256ַԪ)Ϊλһִַвǲַڵһҳ
         IAPдһַԪΪλ(һַԪӦһWord)ÿҳʱ2msַʱ20us
        ע⣺IAPǰرWDT(ѡWDTENΪDisable)ʹWDTúWDTʱ䣬幷
*  עES7P1391̽ο
ѧϰʾʹãûֱôķջеκηΡ
*******************************************************/
#include <hic.h>

#define CLRWDT()   {__Asm CWDT;}    //궨幷ָ

#define STARTADDR    0x0200     //궨IAPʼַ
#define ENDADDR      0x1EFF     //궨IAPַ
#define WRDATA       0x55AA     //궨д

unsigned char dataerr = 0;      //0дȣ1д

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH=0; IAAH<=0x03; IAAH++)
    {
        for (IAAL=0; IAAL<0xFF; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
}

/******************************************************
void StartIAP(void)
  ʼIAPע⣺IAP̶ʽʹʱɸı
ֵ
ֵ
ֵ
*******************************************************/
void StartIAP(void)
{
    __asm{
          MOVI 0x55
          MOVA ROMCH
          NOP           //ȴ8ָڣʹʱɸı
          NOP
          NOP
          NOP
          NOP
          NOP
          NOP
          NOP
          MOVI 0xAA
          MOVA ROMCH
          NOP           //ȴ8ָڣʹʱɸı
          NOP
          NOP
          NOP
          NOP
          NOP
          NOP
          NOP
          BSS ROMCL,WR     //̲
          JBC ROMCL,WR
          goto $-1         //ȴ
        }
}

/*******************************************************
void FlashErsPage(unsigned int addr)
  ַڵҳ(256 word)ַΧ0x0000~0x1EFF
ֵFlashַaddr
ֵ
ֵ
*******************************************************/
void FlashErsPage(unsigned int addr)
{
    CLRWDT();
    ROMCL = 0x50;       //ѡIAP
    FPEE = 1;           //洢ģʽ
    FRAH = addr>>8;
    FRAL = addr;
    FRAHN = ~FRAH;      //IAP/ַ̱ȡ߼
    FRALN = ~FRAL;     
    WREN = 1;           //ʹܲ/̹
    while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }
    StartIAP();         //ʼIAP
    GIE = 1;            //ȫж
    ROMCL = 0x00;       //˳IAP
}

/*******************************************************
unsigned int FlashRdData(unsigned int addr)
  FlashַָݣַΧ0x0000~0x1EFF
ֵFlashַaddr
ֵ
ֵFlashַָ
*******************************************************/
unsigned int FlashRdData(unsigned int addr)
{
    CLRWDT();
    ROMCL = 0x50;       //ѡIAP
    FRAH = addr>>8;
    FRAL = addr;
    __Asm TBR;          //ָ
    return (unsigned int)ROMDH<<8 | ROMDL;
    //ROMCL = 0x00;       //˳IAP
}

/*******************************************************
void FlashWrData(unsigned int addr, unsigned int word)
  дFlashַָݣַΧ0x0000~0x1EFF
ֵFlashַaddrдword
ֵ
ֵ0:дʧܣ1:дɹ
*******************************************************/
unsigned char FlashWrData(unsigned int addr, unsigned int word)
{
    unsigned char rmdh,rmdl;      //ʱROMDHROMDLֵ
    CLRWDT();
    ROMCL = 0x50;       //ѡIAP
    FPEE = 0;           //洢ģʽ
    ROMDH = word>>8;    //дWordĸֽ
    ROMDL = word;
    FRAH = addr>>8;     //IAP̵ַ
    FRAL = addr;
    FRAHN = ~FRAH;      //IAP/ַ̱ȡ߼
    FRALN = ~FRAL;       
    WREN = 1;           //ʹܱ
    while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }
    StartIAP();         //ʼIAP
    GIE = 1;            //ȫж
    rmdh = ROMDH++;
    rmdl = ROMDL++;
    __Asm TBR;          //ָ
    if (ROMDH!=rmdh || ROMDL!=rmdl)
        return 0;
    return 1;
    //ROMCL = 0x00;       //˳IAP
}

/*******************************************************
void main(void)
  IAPַ0000~1EFF
ֵ
ֵ
ֵ
*******************************************************/
void main(void)
{
    unsigned char i;
    unsigned int j;
    unsigned int flashaddr;     //ַflashд

    RAMclear();
    GPIOInit();
    CLRWDT();

/************IAPҳΪλÿҳ256Word*******/
    flashaddr = STARTADDR;      //flashaddrַҳ
    j = (ENDADDR>>8)-(STARTADDR>>8)+1;      //ʼַͽַ֮Ҫҳ
    for (i=0; i<j; i++)
    {
        FlashErsPage(flashaddr);
        flashaddr += 0x100;     //һҳ
    }
    ROMCL = 0x00;       //˳IAP
    CLRWDT();

/******************IAPд벢У********************/
    for (flashaddr=STARTADDR; flashaddr<=ENDADDR; flashaddr++)
    {
        i = FlashWrData(flashaddr, WRDATA);
        if (i != 1)
            dataerr = 1;        //У
    }
    ROMCL = 0x00;       //˳IAP
    CLRWDT();

/******************IAPУ(ʾ)********************/
    for (flashaddr=STARTADDR; flashaddr<=ENDADDR; flashaddr++)
    {
        j = FlashRdData(flashaddr);
        if (j != WRDATA)
            dataerr = 1;        //У
    }
    ROMCL = 0x00;       //˳IAP
    CLRWDT();

    while (1)
    {
        CLRWDT();
    }
}