/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  uart.c
*  :  LuF
*  :  V1.0
*  :  2018/7/24
*  :  UARTͨ
          1.첽շ֧8/9λݸʽָ֧ٵģʽʼ㹫ʽ 
            ģʽBRGHn=0, baud rate=Fosc/(64(BRnR<7:0>+1))
            ģʽBRGHn=1, baud rate=Fosc/(16(BRnR<7:0>+1))
          2.UARTͨѶʱжϱ־RXnIFɽݼĴĶRXnEN㡣ݱ뼰ʱȡܵ
            FIFOжϱ־TXnIFɸλдTXnEN㡣
            עUART1Ϊʾֻڴ̻ӦݽպͷͶ˿ڣӦUARTĴɡ
*  ע:  ES7P202x
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

unsigned char RecData,SendData,i;
void RAMClear(void);

/*********************************************************
:	void isr(void) interrupt
  :	жϷ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void isr(void) interrupt
{
    if(RX1IE && RX1IF)		
    {		
        RecData = RX1B;          //ȡֽ
        SendData = RecData;      //׼ֽ
        while(!TRMT1);           //ȴλĴTXR
        TX1B = SendData;         //
    }
}
/*********************************************************
:	void main()
  :	
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main()
{   
    RAMClear();
    
    unsigned char StartChar[]="<UART>";
    
    PC = 0x00;            //PC˿͵ƽ 
    PCT5 = 0;             //TX
    PCT4 = 1;             //RX
    PCPU4 = 1;            //ʹPC4
    PCS = 0x00;	          //PC˿ΪI/O 
    
    BRGH1 = 1;	          //ģʽ
    BR1R = 103;	          //9600bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
    TX1LEN = 0;	          //8λݸʽ
    RX1EN = 1;	          //UARTʹ	
    TX1EN = 1;	          //UARTʹ	
    
    for(i=0;i<7;i++)   
    {
        while(!TRMT1);           	//ȴλĴTXR
        TX1B = StartChar[i];   		//ַ
    }
    RX1IE = 1;	             		//ʹUARTж
    GIE = 1;                		//ȫж
    while(1);
}

/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
	__asm{				    //ַ0x0000~0x05FF
		MOVI 0x00			
		MOVA IAAH 
		MOVI 0x00			
		MOVA IAAL 
		CLR	 IAD 
		INC	 IAAL,1
		JBS	 PSW,C
		GOTO $-3
		INC IAAH,1
		MOVI 0x06
		SUB  IAAH,0
		JBS	 PSW,C	
		GOTO $-8
	}
}
