/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  capture.c
*  :  LuF
*  :  V1.0
*  :  2018/7/24
*  :  T21׽
          1.T21׽źأ趨ÿ4ز׽1Σ׽100δͷʼ
          2.Ƶ16MHz趨׽ʱӷƵ116ʱΪ1us
            עʹӲʱʹT20׽ģ飬ΪӦ벶׽ͬʱΪͨѶڣɳ󴥷жϡ
          3.1kHzԴΪֵΪ
            1/1kHz  4ƥش/1/16MHz  16= 40000xFA0
*  ע:  ES7P202x
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

void RAMClear(void);

#define CaptureOffset 2             //׽ֵжϺ嶨ʱֵʵִָеʱ䣬ֲ´β׽

unsigned int PluseWidth[100];       //׽
unsigned char count;                //׽ݼ

/*********************************************************
: void isr(void) interrupt
  : жϷ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/ 
void isr(void) interrupt
{
    unsigned char i;
    if(T21MIE0 && T21MIF0)            //׽ʱжϱ־
    {
        T21H = 0 ;                    //嶨ʱֵ
        T21L = 0 ;
 
        PluseWidth[count] = ((unsigned int)(T21CP0H << 8) & 0xFF00) + (unsigned int)T21CP0L + CaptureOffset;	//ȡ׽

        count++;	
        if(count>=100)                //׽100
        {
            for(i=0;i<100;i++)
            {
                PluseWidth[i] = 0;    //0
            }
            count = 0;                //0
        }

        T21MIF0 = 0 ;                 //жϱ־
    }
}

/*********************************************************
: void main()
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main() 
{                                  
    RAMClear();                    //RAM

    PCPD0 = 1;                     //ʹ
    PCOD0 = 0;                     //ֹ©
    PCS0 = 0;                      //PC0ΪI/O
    PCT0 = 1;                      //PC0/T21CI0Ϊ벶׽

    count = 0;                     //0

    T21EN = 1;                     //ʹT21ʱ
    T21CM = 0x0F;                  //T21ΪԤƵΪ1:16
    T21CL = 0x60;                  //׽ģʽ,ÿ4ز׽һ

    T21H = 0;                      //T21ʱ
    T21L = 0;
    T21MIE0 = 1;                   //๦жʹ
    
    GIE = 1;                       //ʹȫж

    while(1) ;
}

/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
	__asm{				    //ַ0x0000~0x05FF
		MOVI 0x00			
		MOVA IAAH 
		MOVI 0x00			
		MOVA IAAL 
		CLR	 IAD 
		INC	 IAAL,1
		JBS	 PSW,C
		GOTO $-3
		INC IAAH,1
		MOVI 0x06
		SUB  IAAH,0
		JBS	 PSW,C	
		GOTO $-8
	}
}
