/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  spi_master.c
*  :  WangYQ
*  :  v1.0iDesigner(v4.2.3.159) + HRCC(v1.2.0.102)
*  :  2018/08/07
*  :  SPIģʽʾ
          PA6NSS
          PB4SCK
          PB5MOSI
*  ע:  ES7P001оƬ̽ο
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define IT_SEND      //ע͵òѯͣжϷ
#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ

typedef unsigned char uchar;
typedef unsigned int uint;

#define TXBUF_SIZE 16
uchar txbuf[TXBUF_SIZE] = {0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15};
uchar txpos;

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH=0; IAAH<=0x03; IAAH++)
    {
        for (IAAL=0; IAAL<0xFF; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;    //ѡӦ˿ΪIO
    PAT = 0xFE;     //PA<7:1>Ϊ
    PBT = 0x3F;     //PB<5:0>Ϊ
    PCT = 0x03;     //PC<1:0>Ϊ
    PAPU = 0xFE;    //PA<7:1>ʹ
    PBPU = 0x3F;    //PB<5:0>ʹ
    PCPU = 0x03;    //PC<1:0>ʹ
    PA &= 0xFE;
    PB &= 0x3F;
}

/**********************************************
void Init_spi(void)
  SPIʼ
ֵ
ֵ
ֵ
**********************************************/
void Init_spi(void)
{
    SPIRST = 1;     //λSPI
    while(SPIRST)
        ;
    SPICON0 = 0xF0;       //CKS = Fosc/16շ
    SPICON1 |= 0<<6;      //0:طͣȣ½ؽգ󣩣
    //SPICON1 |= 1<<6;      //1:½طͣȣؽգ󣩣
    //SPICON1 |= 2<<6;      //2:ؽգȣ½طͣ󣩣
    //SPICON1 |= 3<<6;      //3:½ؽգȣطͣ󣩣
    MS = 0;         //0ģʽ1ӻģʽ
    TBIE = 1;        //SPIж
    SPIEN = 1;      //SPIʹ
}

/**********************************************
void isr(void) interrupt 
  жϷ
ֵ
ֵ
ֵ
**********************************************/
#ifdef IT_SEND
void isr(void) interrupt
{
    if (TBIE==1 && TBIF==1)     //SPIж
    {
        SPITBW = txbuf[txpos++];   //ѭͻ
        if (txpos >= 16)
            txpos = 0;
    }
    SPI_GIEIF = 0;  //жϱ־
}
#endif

/**********************************************
void main(void) 
  
ֵ
ֵ
ֵ
**********************************************/
void main(void) 
{
    uint i;
    txpos = 0;
    //RAMclear();
    GPIOInit();
    PAT6 = 0;       //NSSΪ
    PA6 = 0;        //ʹƬѡ
    PBT4 = 0;       //SCKΪ
    PBT5 = 0;       //MOSIΪ
    Init_spi();
    SPI_GIEIE = 1;  //SPIж
    GIE = 1;    //ж
    while(1)
    {
#ifndef IT_SEND
        while (!IDIF) ;
        SPITBW = txbuf[txpos % 16];   //ѭͻ
#endif
    }
}
