/*******************************************************
*Copytight(C),2017,Shanghai Eastsoft Microelectronics Co.,Ltd.
*ļiap_flash.c
*  ߣwangyq
*  v1.1iDesigner(v4.2.3.159) + HRCC(v1.2.0.102)
*  ڣ2018/12/20
*  IAPʹFRENַ0x0000~0x1EFF0x0000~0x00FFΪ1ҳ
         0x0100~0x01FFΪ2ҳ0x0200~0x02FFΪ3ҳԴơ
         IAPҳ(256ַԪ)Ϊλһִַвǲַڵһҳ
         IAPдһַԪΪλ(һַԪӦһWord)ÿҳʱ2msַʱ20us

        ע⣺IAPǰرWDT(ѡWDTENΪDisable)ʹWDTúWDTʱ䣬幷
*  עES7P001̽ο
ѧϰʾʹãûֱôķջеκηΡ
*******************************************************/
#include <hic.h>

#define CLRWDT()   {__Asm CWDT;}    //궨幷ָ

#define STARTADDR    0x0200     //궨IAPʼַ
#define ENDADDR      0x1EFF     //궨IAPַ
#define WRDATA       0x55AA     //궨д

unsigned char dataerr = 0;      //0дȣ1д

unsigned char CallFlashEn,FlashEwEn;//

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH=0; IAAH<=0x03; IAAH++)
    {
        for (IAAL=0; IAAL<0xFF; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;    //ѡӦ˿ΪIO
    PAT = 0xFE;     //PA<7:1>Ϊ
    PBT = 0x3F;     //PB<5:0>Ϊ
    PCT = 0x03;     //PC<1:0>Ϊ
    PAPU = 0xFE;    //PA<7:1>ʹ
    PBPU = 0x3F;    //PB<5:0>ʹ
    PCPU = 0x03;    //PC<1:0>ʹ
    PA &= 0xFE;
    PB &= 0x3F;
}

/******************************************************
void StartIAP(void)
  ʼIAPע⣺IAP̶ʽʹʱɸı
ֵ
ֵ
ֵ
*******************************************************/
void StartIAP(void)
{
    __asm{
          MOVI 0x55
          MOVA ROMCH
          MOVI 0xFF     //8NOP俪ʼ
          SECSEL &FlashEwEn& % 0x80//ѡڵsection
          XOR &FlashEwEn& % 0x80,0//0xFF xor 0xAA = 0x55
          SECSEL &CallFlashEn& % 0x80//ѡڵsection
          XOR &CallFlashEn& % 0x80,0//CallFlashEnڵúǰΪ0x550x55 xor 0x55 = 0x00
          JBS PSW,Z//Ϊ0x00ִȷһNOP
          GOTO $+3
          NOP//8NOP
          MOVI 0xAA
          MOVA ROMCH
          MOVI 0xFF     //8NOP俪ʼ
          SECSEL &FlashEwEn& % 0x80//ѡڵsection
          XOR &FlashEwEn& % 0x80,0//0xFF xor 0xAA = 0x55
          SECSEL &CallFlashEn& % 0x80//ѡڵsection
          XOR &CallFlashEn& % 0x80,0//CallFlashEnڵúǰΪ0x550x55 xor 0x55 = 0x00
          JBS PSW,Z//Ϊ0x00ִȷһNOP
          GOTO $+3
          NOP//8NOP
          BSS ROMCL,WR     //̲
          JBC ROMCL,WR
          goto $-1         //ȴ
        }
}

/*******************************************************
void FlashErsPage(unsigned int addr)
  ַڵҳ(256 word)ַΧ0x0000~0x1EFF
ֵFlashַaddr
ֵ
ֵ
*******************************************************/
void FlashErsPage(unsigned int addr)
{
	unsigned char gie_bk = GIE;		//GIE
    CLRWDT();
	while(GIE == 1)GIE = 0;            //IAPǰرȫж  
    ROMCL = 0x50;       //ѡIAP
    FPEE = 1;           //洢ģʽ
    FRAH = addr>>8;
    FRAL = addr;
    FRAHN = ~FRAH;      //IAP/ַ̱ȡ߼
    FRALN = ~FRAL;     
	FlashEwEn = 0xAA;//
    WREN = 1;           //ʹܲ/̹ 
    StartIAP();         //ʼIAP
	CallFlashEn = 0;//
	FlashEwEn = 0;
    ROMCL = 0x00;       //˳IAP
	GIE = gie_bk;            //ָȫж
}

/*******************************************************
unsigned int FlashRdData(unsigned int addr)
  FlashַָݣַΧ0x0000~0x1EFF
ֵFlashַaddr
ֵ
ֵFlashַָ
*******************************************************/
unsigned int FlashRdData(unsigned int addr)
{
	unsigned int data;
	unsigned char gie_bk = GIE;		//GIE
    CLRWDT();
	while(GIE == 1)GIE = 0;            //IAPǰرȫж  
    ROMCL = 0x50;       //ѡIAP
    FRAH = addr>>8;
    FRAL = addr;
    __Asm TBR;          //ָ
    data = (unsigned int)ROMDH<<8 | ROMDL;
    GIE = gie_bk;            //ָȫж
	return data;
}

/*******************************************************
void FlashWrData(unsigned int addr, unsigned int word)
  дFlashַָݣַΧ0x0000~0x1EFF
ֵFlashַaddrдword
ֵ
ֵ0:дʧܣ1:дɹ
*******************************************************/
unsigned char FlashWrData(unsigned int addr, unsigned int word)
{
    unsigned char rmdh,rmdl;      //ʱROMDHROMDLֵ
	unsigned char gie_bk = GIE;		//GIE
    CLRWDT();
	while(GIE == 1)GIE = 0;            //IAPǰرȫж  
    ROMCL = 0x50;       //ѡIAP
    FPEE = 0;           //洢ģʽ
    ROMDH = word>>8;    //дWordĸֽ
    ROMDL = word;
    FRAH = addr>>8;     //IAP̵ַ
    FRAL = addr;
    FRAHN = ~FRAH;      //IAP/ַ̱ȡ߼
    FRALN = ~FRAL;       
	FlashEwEn = 0xAA;//
    WREN = 1;           //ʹܱ 
    StartIAP();         //ʼIAP
	CallFlashEn = 0;//
	FlashEwEn = 0;
    rmdh = ROMDH++;
    rmdl = ROMDL++;
    __Asm TBR;          //ָ
    if (ROMDH!=rmdh || ROMDL!=rmdl)
	{
        ROMCL = 0x00;       //˳IAP
		return 0;
	}
	FRAH = 0xFF;//ָõĵַռ
	FRAH = 0xFF;//ָõĵַռ
	ROMDH = 0xFF;//ݳʼΪ0xFF
	ROMDL = 0xFF;//ݳʼΪ0xFF
    ROMCL = 0x00;       //˳IAP
	GIE = gie_bk;            //ָȫж
    return 1;
}

/*******************************************************
void main(void)
  IAPַ0000~1EFF
ֵ
ֵ
ֵ
*******************************************************/
void main(void)
{
    unsigned char i;
    unsigned int j;
    unsigned int flashaddr;     //ַflashд

    RAMclear();
    GPIOInit();
    CLRWDT();

/************IAPҳΪλÿҳ256Word*******/
    flashaddr = STARTADDR;      //flashaddrַҳ
    j = (ENDADDR>>8)-(STARTADDR>>8)+1;      //ʼַͽַ֮Ҫҳ
    for (i=0; i<j; i++)
    {
		CallFlashEn = 0x55;		//CallFlashEnֵ0x55ִв̲
        FlashErsPage(flashaddr);
        flashaddr += 0x100;     //һҳ
    }
    ROMCL = 0x00;       //˳IAP
    CLRWDT();

/******************IAPд벢У********************/
    for (flashaddr=STARTADDR; flashaddr<=ENDADDR; flashaddr++)
    {
		CallFlashEn = 0x55;		//CallFlashEnֵ0x55ִв̲
        i = FlashWrData(flashaddr, WRDATA);
        if (i != 1)
            dataerr = 1;        //У
    }
    ROMCL = 0x00;       //˳IAP
    CLRWDT();

/******************IAPУ(ʾ)********************/
    for (flashaddr=STARTADDR; flashaddr<=ENDADDR; flashaddr++)
    {
        j = FlashRdData(flashaddr);
        if (j != WRDATA)
            dataerr = 1;        //У
    }
    ROMCL = 0x00;       //˳IAP
    CLRWDT();

    while (1)
    {
        CLRWDT();
    }
}