/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  adc_ldo.c
*  :  WangYQ
*  :  v1.0iDesigner(v4.2.3.162) + HRCC(v1.2.0.102)
*  :  2019/07/19
*  :  ADCͨʾ
          PB3ģ˿
          PA1TX
          PA2RX
          תADֵͨڷ͵λ9600bpsѡVDDΪοѹˣ
          תΪ:1.ѡڲLDOΪͨDatasheetLDOѹʱVDD
		  2.ʹһVDDΪοѹָͨĵѹֵ
*  ע:  ES7P001оƬ̽ο
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define LDOV		1640		//ڲLDOѹֵλmV
#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ

typedef unsigned char uchar;
typedef unsigned int uint;

uint vdd_volt;
uint adc_value;
uchar str[] = "ͨ תֵΪ:     mV\r\n\0";

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH=0; IAAH<=0x03; IAAH++)
    {
        for (IAAL=0; IAAL<0xFF; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
}

/**********************************************
UART_send(uchar *str,uchar ch,uint value)
  UARTͺ
ֵַָ룬ͨADCתֵ
ֵ
ֵ
**********************************************/
void UART_send(uchar *str,uchar ch,uint value)
{
    *(str+4) = ch+'0';
    *(str+16) = value/1000+'0';
    *(str+17) = value%1000/100+'0';
    *(str+18) = value%100/10+'0';
    *(str+19) = value%10+'0';
    while(*str)
    {
        while(!TRMT);
        TXB = *str++;
    }
}
/**********************************************
ADC_convert(uchar ch)
  ADCת
ֵתͨch
ֵ
ֵת12λ
**********************************************/
uint ADC_convert(void)
{
    ADTRG = 1;      //ADת
    while(ADTRG);
    ADIF = 0;

    return (uint)ADCRH<<8 | ADCRL;
}

/**********************************************
main()
  ,ѡAIN5ֵͨUART͵λ
ֵ
ֵ
ֵ
**********************************************/
void main(void) 
{
    uint i = 800;         //ʱ
	uint convert_value;
	uint adc_volt;

    //RAMclear();
    CLRWDT();

/****************ʼADC********************/
    ANSL5 = 0;          //ѡAIN5Ϊģ
	PBPU2 = 0;			//ȡPB3
	PBPU3 = 0;
	PBPU4 = 0;
    ADCCL |= 0xF0;      //ADCCL<7:4>ѡͨ
    ADCCL &= 0x8F;      //ѡڲLDO
    ADCCH = 0xC8;       //λ;ʱFOSC/16;οԴVDD,VSS
	PWEN &= 0x7F;		//ADVREFS2 = 0

	PBPU3 = 0;
    PBT3 = 1;
    SMPS = 1;           //ӲƲADTRG=1ʱADת
    ADEN = 1;           //ʹADCģ
	
/****************ʼUART*******************/
    PAT1 = 0;       //TX
    TXM = 0;        //8λݷ͸ʽ
    BRGH = 0;       //ʵģʽ=Fosc/(64*(BRR<7:0>+1))
    BRR = 25;       //=16MHz/(64*26)9600bps
    TXEN = 1;       //򿪷

    while(i--)          //ʹADڵһת֮ǰʱ80us
        ;         
    ADC_convert();      //״תֵ׼ȷ

/********1.ڲLDOѹVDDѹ********/
	convert_value = ADC_convert();
	vdd_volt = (uint)((unsigned long)LDOV * 0xFFF / convert_value);		//LDOѹʱVDDѹΪĲοѹλmV

/********2.VDDΪοѹָͨĵѹ****/
	ADCCL |= 0xF0;      //ADCCL<7:4>ѡͨ
    ADCCL &= 0x5F;      //ѡͨ5

    while(1)
    {
        adc_value = ADC_convert();
		adc_volt = (uint)((unsigned long)vdd_volt * adc_value / 0xFFF);		//תΪͨѹλmV
        UART_send(str, 5, adc_volt);		//תĵѹֵ
        for(i = 0;i<50000;i++);        //ʱ
        for(i = 0;i<50000;i++);
        CLRWDT();
    }
}
