        .syntax unified
        .cpu cortex-m0
        .arch armv6-m
        .fpu softvfp
        .thumb

/*  Stack Configuration
    Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
*/
       
        .equ Stack_Size,  0x00000400

        .section  .stack, "wa"
        .align 3
        .global Stack_Mem
        .global Stack_Size
Stack_Mem:     
        .if Stack_Size
        .space   Stack_Size
        .endif
        .size    Stack_Mem,.-Stack_Mem
        .set     Stack_Size,.-Stack_Mem
__initial_sp:


/*
 <h> Heap Configuration
   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
</h>
*/

        .equ     Heap_Size,       0x00000010

        .section  .heap, "wa"
        .align 3

        .global Heap_Mem_Start
        .global Heap_Mem_End
Heap_Mem_Start:     
        .if Heap_Size
        .space   Heap_Size
        .endif        
Heap_Mem_End:     


/* Vector Table Mapped to Address 0 at Reset*/
                                        
        .section 	.vectors, "wax"
        .global  __vector
        .type  __vector, %object
        
__vector: 
                .long     __initial_sp							 /* Top of Stack*/
                .long     Reset_Handler				 /*Reset_Handler*/    
                .long     NMI_IRQHandler				 /* NMI Handler*/
                .long     HardFault_IRQHandler         /* Hard Fault Handler*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     SVC_IRQHandler               /* SVCall Handler*/
                .long     0                            /* Reserved*/
                .long     0                            /* Reserved*/
                .long     PendSV_IRQHandler            /* PendSV Handler*/
                .long     SysTick_IRQHandler           /* SysTick Handler*/

                /* External Interrupts*/
                .long     PINT0_IRQHandler					/*16, pint0 IRQIRQHandler*/
                .long     PINT1_IRQHandler					/*17, pint1 IRQIRQHandler*/
                .long     PINT2_IRQHandler					/*18, pint2 IRQIRQHandler*/
                .long     PINT3_IRQHandler					/*19, pint3 IRQIRQHandler*/
                .long     PINT4_IRQHandler					/*20, pint4 IRQIRQHandler*/
                .long     PINT5_IRQHandler					/*21, pint5 IRQIRQHandler*/
                .long     PINT6_IRQHandler					/*22, pint6 IRQIRQHandler*/
                .long     PINT7_IRQHandler					/*23, pint7 IRQIRQHandler*/
                .long     T16N0_IRQHandler					/*24, t16n0 IRQIRQHandler*/
                .long     T16N1_IRQHandler					/*25, t16n1 IRQIRQHandler*/
                .long     T16N2_IRQHandler					/*26, t16n2 IRQIRQHandler*/
				.long	  T16N3_IRQHandler					/*27, t16n3 IRQIRQHandler*/
                .long     T32N0_IRQHandler					/*28, t32n0 IRQIRQHandler*/
                .long     T32N1_IRQHandler					 /*29, Reserved   			 */
                .long     T32N2_IRQHandler                   /*30, Reserved              */
                .long     0                                  /*31, Reserved              */
                .long     WDT_IRQHandler					/*32, wdt IRQIRQHandler     */
                .long     RTC_IRQHandler						/*33, rtc IRQIRQHandler     */
                .long     0									/*34, Reserved			    */
                .long     ADC_IRQHandler						/*35, adc  IRQIRQHandler    */
                .long     LCD_IRQHandler					/*36, LCDINT IRQHandler		   */
                .long     LVD_IRQHandler					/*37, lvd IRQIRQHandler    */
                .long     RTCHW_IRQHandler					/*38, RTCHW IRQHandler	    */
                .long     UART0_IRQHandler					/*39, uart0 IRQIRQHandler   */
                .long     UART1_IRQHandler					/*40, uart1 IRQIRQHandler   */
                .long     UART2_IRQHandler					/*41, uart2 IRQIRQHandler   */
                .long     UART3_IRQHandler					/*42, uart3 IRQIRQHandler   */
                .long     EUART0_IRQHandler					/*43, EUART0 IRQIRQHandler  */
                .long     EUART1_IRQHandler					/*44, EUART1 IRQHandler		*/
                .long     SPI_IRQHandler					/*45  SPIINT IRQHandler    */
                .long     IIC_IRQHandler					/*46, I2CINT IRQHandler    */
                .long     0									/*47, Reserved    */

               .size  __vector, .-__vector
                
				.thumb
                .text
                .thumb_func
                .global  Reset_Handler
                .type Reset_Handler,%function
Reset_Handler:
           
	          .extern main
                .extern __start
                .extern InitRam
                LDR     R0, =InitRam
                BLX     R0
                LDR     R0, =main
                BLX      R0
             
               .size  Reset_Handler, .-Reset_Handler
 
                .text
/* Dummy Exception IRQHandlers (infinite loops which can be modified)*/                
               
                 .weak NMI_IRQHandler
                 .type NMI_IRQHandler,%function
NMI_IRQHandler:     
                 B       .
                 .size  NMI_IRQHandler, .-NMI_IRQHandler
                
                 .weak  HardFault_IRQHandler
                 .type  HardFault_IRQHandler,%function
HardFault_IRQHandler:
                B .
                .size  HardFault_IRQHandler, .-HardFault_IRQHandler
                
                .weak SVC_IRQHandler
                .type SVC_IRQHandler,%function
SVC_IRQHandler:			
                B       .
                .size  SVC_IRQHandler, .-SVC_IRQHandler
              
                
                .weak  PendSV_IRQHandler
                .type  PendSV_IRQHandler,%function
PendSV_IRQHandler:
								
                B	.
		          .size  PendSV_IRQHandler, .-PendSV_IRQHandler
                 
                .weak  SysTick_IRQHandler
                .type  SysTick_IRQHandler,%function
SysTick_IRQHandler: 
                B		.
                .size  SysTick_IRQHandler, .-SysTick_IRQHandler

                .global Default_IRQHandler
                .type  Default_IRQHandler,%function
Default_IRQHandler: 
                B       .
                .size  Default_IRQHandler, .-Default_IRQHandler
                .macro IRQ handler
                .weak \handler
                .set \handler,Default_IRQHandler 
                .endm
                
				IRQ	PINT0_IRQHandler      
				IRQ	PINT1_IRQHandler      
				IRQ	PINT2_IRQHandler      
				IRQ	PINT3_IRQHandler      
				IRQ	PINT4_IRQHandler      
				IRQ	PINT5_IRQHandler      
				IRQ	PINT6_IRQHandler      
				IRQ	PINT7_IRQHandler      
				IRQ	T16N0_IRQHandler      
				IRQ	T16N1_IRQHandler      
				IRQ	T16N2_IRQHandler      
				IRQ	T16N3_IRQHandler      
				IRQ	T32N0_IRQHandler       
				IRQ	T32N1_IRQHandler       
				IRQ	T32N2_IRQHandler    
				IRQ	WDT_IRQHandler      
				IRQ	RTC_IRQHandler      
				IRQ	ADC_IRQHandler 
				IRQ 	LCD_IRQHandler
				IRQ	LVD_IRQHandler 
				IRQ	RTCHW_IRQHandler     
				IRQ	UART0_IRQHandler     
				IRQ	UART1_IRQHandler     
				IRQ	UART2_IRQHandler     
				IRQ	UART3_IRQHandler       
				IRQ	EUART0_IRQHandler       
				IRQ	EUART1_IRQHandler    
				IRQ	SPI_IRQHandler    
				IRQ	IIC_IRQHandler       

                .end
