/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  Liut
*  :  V1.00
*  :  2018/07/04
*  :  Bootloaderʾ
          MCUHR8P296
          RXPC1  TXPC0  BootPinPC2
          ʣ9600  УλżУ  ֹͣλ1λ
          ʾοĵ AN082_Ӧñʼ_ES8PϵMCU bootloader
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "HR8P296.h"
#include "macro.h"
#include "typedef.h"
#include "lib_flashiap.h"

extern isp_data_t g_isp_data;
extern uint32_t  g_boot_timer;
extern uint8_t   g_boot;

void uart_init(UART_TypeDef* uartx);
void uart_proc_fsm(void);
void fsm_init(void);
void JumpToApp(uint32_t addr);

/***************************************************************
systick_init
  : Systickʼ
ֵ
ֵ
ֵ 
***************************************************************/
void systick_init(void)
{
  SysTick->CTRL = 0x07;
  SysTick->LOAD = 16000;  //ϵͳʱ16M1msһж
  SysTick->VAL = 0;
}

/***************************************************************
gpio_init
  : GPIOʼ
ֵ
ֵ
ֵ 
***************************************************************/
void gpio_init(void)
{
  SCU->PROT.Word = 0X55AA6996;
  SCU->PCLKEN0.GPIO_EN = 1;
  SCU->PCLKEN1.UART0_EN = 1;
  SCU->PCLKEN0.IAP_EN = 1;
  

  GPIO->PROT.Word = 0x78879669;
  //BootPIN:PC2
  GPIO->PCDIR.DIR_2 = 1; //ر
  GPIO->PCPDEN.PDEN_2 = 1; //

  //RX:PC1
  GPIO->PCDIR.DIR_1 = 1; //ر
  GPIO->PCFUN0.PC1 = 2;   //FUNC2 RXD

  //TX:PC0
  GPIO->PCDIR.DIR_0 = 0; //
  GPIO->PCFUN0.PC0 = 2;   //FUNC2 TXD

  GPIO->PROT.Word = 0;
}

int SystemInit(void)
{

  return 0;
}

int main()
{
  gpio_init();
  uart_init(UART0);
  fsm_init();
  NVIC_EnableIRQ(UART0_IRQn);
  systick_init();
  while(1)
  {
    
    if(g_isp_data.triger == 1)
    {
      __disable_irq();  //ٽδ뱣
      while(g_isp_data.triger == 1)
      {
        uart_proc_fsm();  //isp״̬
      }
      __enable_irq();
    }
    if(g_boot == 1)  //Ҫflash
    {
      JumpToApp(APP_ADDR);
    }
  }
}
