#include "HR8P296.h"
#include "macro.h"
#include "typedef.h"
#include "string.h"
#include "lib_flashiap.h"


/***************************************************************
get_cusum32
  : ȡ32bitۼӺ
ֵʼַֽڳ
ֵ
ֵ32bitۼӺͽ
***************************************************************/
//#ifdef __IAR_SYSTEMS_ICC__		/*IAR compiler*/
//__ramfunc
//#endif
uint32_t  get_cusum32(uint32_t* data_ptr, uint32_t len)
{
  uint32_t  i,buf32;
  if((((uint32_t)data_ptr)%4 != 0) || (len%4 != 0))
  {
    return 0;
  }
  buf32 = 0;
  for(i=0; i<len; i+=4)
  {
    buf32 += *(data_ptr++);
  }
  return buf32;
}

/***************************************************************
check_empty
  : 
ֵʼַֽڳ
ֵ
ֵ32bitۼӺͽ
***************************************************************/
//#ifdef __IAR_SYSTEMS_ICC__		/*IAR compiler*/
//__ramfunc
//#endif
uint8_t check_empty(uint32_t* data_ptr, uint32_t len)
{
  uint32_t  i;
  if((((uint32_t)data_ptr)%4 != 0) || (len%4 != 0))
  {
    return FAILED;
  }
  for(i=0; i<len; i+=4)
  {
    if(*(data_ptr++) != 0xFFFFFFFF)
    {
      break;
    }
  }
  if(i!=len)
  {
    return FAILED;
  }
  else
  {
    return SUCCESS;
  }
}

/***************************************************************
  FlashIap_Unlock
    IAP
  ֵ
  ֵ
  ֵɹʧ
 ***************************************************************/
#ifdef __IAR_SYSTEMS_ICC__		/*IAR compiler*/
__ramfunc
#endif
uint8_t FlashIap_Unlock(void)
{
  uint16_t  Temp16;

  FlashIAP_RegUnLock();              // IAP

  FlashIAP_Enable();                 //ʹIAP

  FlashIAP_REQ();                    //

  //ȴFLASHӦź
  for(Temp16 = 0; Temp16 < 0xFFFF; Temp16++)      
  {
    if(IAP->CON.FLASH_ACK != 0) break;
  }
  if(Temp16 == 0xFFFF)
  {
    return  FAILED;
  }
  else
  {
    return  SUCCESS;
  }

}

/***************************************************************
  FlashIap_WriteEnd
    IAPд
  ֵ
  ֵ
  ֵɹʧ
 ***************************************************************/
#ifdef __IAR_SYSTEMS_ICC__		/*IAR compiler*/
__ramfunc
#endif
uint8_t FlashIap_WriteEnd(void)
{
  uint32_t  Temp32;

  FlashIAP_RegUnLock();                             //IAP

  IAP->CON.Word &= 0xFFFFFFEE;                     //IAPFLASH()

  for(Temp32 = 0; Temp32 < 0xFFFF; Temp32++)      //ȴFLASHӦź()
  {
    if(IAP->CON.FLASH_ACK == 0) break;
  } 

  if(Temp32 == 0xFFFF)
  {
    return  FAILED;
  }
  else
  {
    return  SUCCESS;
  }        
}

/***************************************************************
  IAP_PageErase
    IAPҳ
  ֵҳַ
  ֵ
  ֵɹʧ
 ***************************************************************/
#ifdef __IAR_SYSTEMS_ICC__		/*IAR compiler*/
__ramfunc
#endif
uint8_t IAP_PageErase(uint8_t Page_Addr)
{
  uint16_t  Temp16;
  uint32_t temp;

  temp = __get_PRIMASK();             //ȡPRIMASKĴǰ״̬
  __disable_irq(); //ж

  if(FlashIap_Unlock() == FAILED)
  {
    __set_PRIMASK(temp);             //ָPRIMASKĴ״̬
    return  FAILED;
  }

  IAP->ADDR.IAPPA = Page_Addr;        //ҳַ   

  IAP->TRIG.IAPT = 0x00005EA1;        // 

  for(Temp16 = 0; Temp16 < 0xFFFF; Temp16++)  
  {                                    //жIAP״̬
    if((IAP->STA.Word & (uint32_t)0x01) == (uint32_t)0x00) break; 
  }

  if(Temp16 == 0xFFFF)
  {
    __set_PRIMASK(temp);             //ָPRIMASKĴ״̬
    return  FAILED;
  }

  for(Temp16 = 0; Temp16 < 0xFFFF; Temp16++)  
  {                                   //жIAPҳ־
    if((IAP->STA.Word & (uint32_t)0x02) == (uint32_t)0x02) break;  
  }       

  if(Temp16 == 0xFFFF)
  {
    __set_PRIMASK(temp);           //ָPRIMASKĴ״̬
    return  FAILED;
  }

  if(FlashIap_WriteEnd() == FAILED)
  {
    __set_PRIMASK(temp);           //ָPRIMASKĴ״̬
    return  FAILED;
  }

  __set_PRIMASK(temp);               //ָPRIMASKĴ״̬
//  __enable_irq();
  return  SUCCESS;  
}

/***************************************************************
  FlashIap_WriteCont
    IAPд
  ֵUnit_addrԪַ  Page_addrҳַ  Data32
  ֵ
  ֵɹʧ
 ***************************************************************/
#ifdef __IAR_SYSTEMS_ICC__		/*IAR compiler*/
__ramfunc
#endif
uint8_t FlashIap_WriteCont(uint8_t Unit_addr, uint8_t Page_addr, uint32_t Data32)
{
  uint16_t  temp16;

  IAP->ADDR.IAPPA = Page_addr;       //ַ 
  IAP->ADDR.IAPCA = Unit_addr;

  IAP->DATA.IAPD    = Data32;          //
  IAP->TRIG.IAPT    = 0x00005DA2;      // 

  for(temp16 = 0; temp16 < 0xFFFF; temp16++)  
  {
    if((IAP->STA.Word & (uint32_t)0x01) == (uint32_t)0x00) break;  //жIAP״̬
  }

  if(temp16 == 0xFFFF)
  {
    return  FAILED;
  }


  for(temp16 = 0; temp16 < 0xFFFF; temp16++)  
  {
    if((IAP->STA.Word & 0x04)==0x04) break;  //жIAP̽־
  }       

  if(temp16 == 0xFFFF)
  {
    return  FAILED;
  }

  return  SUCCESS;
}

/***************************************************************
  FlashIap_WriteWord
    IAPдһ
  ֵUnit_addrԪַ  Page_addrҳַ  Data32
  ֵ
  ֵɹʧ
 ***************************************************************/
#ifdef __IAR_SYSTEMS_ICC__		/*IAR compiler*/
__ramfunc
#endif
uint8_t FlashIap_WriteWord(uint8_t Unit_addr, uint8_t Page_addr, uint32_t Data32)
{
  uint32_t temp;

  temp = __get_PRIMASK();             //ȡPRIMASKĴǰ״̬
  __disable_irq(); //ж

  if(FlashIap_Unlock() == FAILED)
  {
    __set_PRIMASK(temp);             //ָPRIMASKĴ״̬
    return  FAILED;  
  }    

  if(FlashIap_WriteCont(Unit_addr, Page_addr, Data32) == FAILED)
  {
    __set_PRIMASK(temp);           //ָPRIMASKĴ״̬
    return  FAILED;
  }

  if(FlashIap_WriteEnd() == FAILED)
  {
    __set_PRIMASK(temp);           //ָPRIMASKĴ״̬
    return  FAILED;
  }

  __set_PRIMASK(temp);               //ָPRIMASKĴ״̬
  return  SUCCESS;    

}

/***************************************************************
  IAP_WordsProgram
    IAPд
  ֵiap_addrFlashַ  data_addrݵַ  iap_lenݳ
  ֵ
  ֵɹʧ
 ***************************************************************/
#ifdef __IAR_SYSTEMS_ICC__		/*IAR compiler*/
__ramfunc
#endif
uint8_t IAP_WordsProgram(uint32_t iap_addr, uint32_t data_addr, uint32_t iap_len)
{
  uint32_t i,data_len;
  uint32_t *ram_addr;
  data_len=iap_len/4;
  ram_addr=(uint32_t *)data_addr;
  if((data_len == 0)&&(data_len>(0x20000-iap_addr)/4))  //ж϶ȡǷϷ
  {
    return  FAILED;
  }
  for(i=0;i<data_len;i++)
  {
    if(FlashIap_WriteWord(iap_addr%1024/4,iap_addr>>10,*ram_addr)==FAILED) 
    {
      return FAILED;
    }
    ram_addr++;
    iap_addr+=4;
  }
  return SUCCESS;
}
