/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:    uart.c
*  :  Liut
*  :  V1.00
*  :  2017/06/29
*  :    UARTģ
*  ע:    HRSDK-GDB-HR8P296 V1.0
            ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "uart.h"

/*********************************************************
: void UARTInit(void)
  : UARTʼӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void UARTInit(void)
{
    GPIO_InitStruType y;
    UART_InitStruType uart0;

    GPIO_RegUnLock();
    y.GPIO_Func = GPIO_Func_2;
    y.GPIO_Direction = GPIO_Dir_In;
    y.GPIO_PUEN = ENABLE;
    y.GPIO_PDEN = DISABLE;
    y.GPIO_OD = DISABLE;
    GPIO_Init(GPIOA, GPIO_Pin_0, &y);               //PA0---RxD
    y.GPIO_Direction = GPIO_Dir_Out;
    y.GPIO_PUEN = DISABLE;
    GPIO_Init(GPIOA, GPIO_Pin_1, &y);               //PA1---TxD
    GPIO_RegLock();

    uart0.UART_StopBits = UART_StopBits_1;          //ֹͣλ1
    uart0.UART_TxMode = UART_DataMode_8;            //ݸʽ8λ
    uart0.UART_TxPolar = UART_Polar_Normal;         //Ͷ˿ڼԣ
    uart0.UART_RxMode = UART_DataMode_8;            //ݸʽ8λ
    uart0.UART_RxPolar = UART_Polar_Normal;         //ն˿ڼԣ
    uart0.UART_BaudRate = 9600;                     //
    uart0.UART_ClockSet = UART_Clock_1;             //ʱѡPclk
    UART_Init(UART0, &uart0);

    UART_TBIMConfig(UART0, UART_TBIM_Byte);
    UART_RBIMConfig(UART0, UART_TBIM_Byte);
    UART_ITConfig(UART0, UART_IT_RB, ENABLE);
    NVIC_Init(NVIC_UART0_IRQn, NVIC_Priority_1, ENABLE);
    UART0_TxEnable();                               //UART0ʹ
    UART0_RxEnable();
}

/*********************************************************
: void UARTTxData(uint8_t *buf, uint8_t n)
  : UART֡
ֵ: bufݻ
        nݸ
ֵ: 
ֵ: 
**********************************************************/
void UARTTxData(uint8_t *buf, uint8_t n)
{
    uint8_t i, check_sum;

    buf[0] = HEAD1;             //֡ͷ0x55
    buf[1] = HEAD2;             //֡ͷ0xAA
    buf[2] = SLAVE_ADDR;        //豸ַ

    check_sum = 0;

    for (i = 0; i < n - 3; i++)
    {
        check_sum ^= buf[i];    //ֽڣ֡ͷ
    }

    buf[n - 3] = check_sum;     //ֵУ
    buf[n - 2] = TAIL1;         //֡β0x5A
    buf[n - 1] = TAIL2;         //֡β0xA5

    UART_ITConfig(UART0, UART_IT_TB, ENABLE);  //ʹܷжϣжжϲ֡
}

/*********************************************************
: uint8_t UARTRxData(uint8_t *buf, uint8_t n)
  : UART֡
ֵ: 
ֵ: bufݻ
        nݸ
ֵ: 
**********************************************************/
uint8_t UARTRxData(uint8_t *buf, uint8_t n)
{
    uint8_t i, check_sum;

    if ((buf[0] != HEAD1) || (buf[1] != HEAD2) || (buf[n - 2] != TAIL1) || (buf[n - 1] != TAIL2)) //ж֡ͷ֡β
    {
        return 1;               //֡
    }

    if (buf[2] != SLAVE_ADDR)   //жϴӻַƥ
    {
        return 1;               //֡
    }

    check_sum = 0;

    for (i = 0; i < n - 3; i++)
    {
        check_sum ^= buf[i];    //ֽڣ֡ͷ
    }

    if (buf[n - 3] != check_sum) //жУʹ
    {
        return 1;               //֡
    }

    return 0;    //ȷ֡
}

