/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:    uart.c
*  :  Liut
*  :  V1.00
*  :  2017/06/29
*  :    UARTģ
*  ע:    HRSDK-GDB-HR8P296 V1.0
            ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "uart.h"

/*********************************************************
: void UARTInit(void)
  : UARTʼӳ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void UARTInit(void)
{
    GPIO_InitStruType y;
    UART_InitStruType uart2;

    GPIO_RegUnLock();
    y.GPIO_Func = GPIO_Func_2;
    y.GPIO_Direction = GPIO_Dir_In;
    y.GPIO_PUEN = ENABLE;
    y.GPIO_PDEN = DISABLE;
    y.GPIO_OD = DISABLE;
    GPIO_Init(GPIOA, GPIO_Pin_12, &y);               //PA12---RxD
    y.GPIO_Direction = GPIO_Dir_Out;
    y.GPIO_PUEN = DISABLE;
    GPIO_Init(GPIOA, GPIO_Pin_13, &y);               //PA13---TxD
    GPIO_RegLock();

    uart2.UART_StopBits = UART_StopBits_1;          //ֹͣλ1
    uart2.UART_TxMode = UART_DataMode_8;            //ݸʽ8λ
    uart2.UART_TxPolar = UART_Polar_Normal;         //Ͷ˿ڼԣ
    uart2.UART_RxMode = UART_DataMode_8;            //ݸʽ8λ
    uart2.UART_RxPolar = UART_Polar_Normal;         //ն˿ڼԣ
    uart2.UART_BaudRate = 1200;                     //(ֻ֧1200bps)
    uart2.UART_ClockSet = UART_Clock_1;             //ʱѡPclk
    UART_Init(UART2, &uart2);

    GPIO_RegUnLock();
    UART_TX2Config(UART_TXPLV_Low, UART_TX2PS_38K); //38K,·ֻõ͵ƽ
    GPIO_RegLock();

    UART_TBIMConfig(UART2, UART_TBIM_Byte);
    UART_RBIMConfig(UART2, UART_TBIM_Byte);
    UART_ITConfig(UART2, UART_IT_RB, ENABLE);
    NVIC_Init(NVIC_UART2_IRQn, NVIC_Priority_1, ENABLE);
    UART2_TxEnable();                               //UART0ʹ
    UART2_RxEnable();
}
