#include "irqhandler.h"
#include "lib_wdt.h"
#include "SysTick.h"

void NMI_IRQHandler(void)
{

}

void HardFault_IRQHandler(void)
{
    while (1)
    {
    }
}

void SVC_IRQHandler(void)
{

}

void PendSV_IRQHandler(void)
{

}

void SysTick_IRQHandler(void)
{
    TimingDelay_Decrement();
}

extern uint32_t count00;
extern uint32_t count01;
extern uint32_t count10;
extern uint32_t count11;
extern uint32_t count20;
extern uint32_t count21;
extern uint32_t buf00[50];
extern uint32_t buf01[50];
extern uint32_t buf10[50];
extern uint32_t buf11[50];
extern uint32_t buf20[50];
extern uint32_t buf21[50];
/*********************************************************
: void T32N0_IRQHandler(void)
  : T32N0ʱжϺ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T32N0_IRQHandler(void)
{
    if (T32Nx_GetFlagStatus(T32N0, TIM_IT_CAP0) != RESET)
    {
        T32Nx_ClearITPendingBit(T32N0, TIM_IT_CAP0);

        buf00[count00]  = T32N0->MAT0.Word;         //T32N_CNT
        buf00[count00 + 1]  = T32N0->MAT2.Word;     //T32N_PRECNT
        count00++;

        if (count00 >= 50)
        {
            count00 = 0;
        }
    }

    if (T32Nx_GetFlagStatus(T32N0, TIM_IT_CAP1) != RESET)
    {
        T32Nx_ClearITPendingBit(T32N0, TIM_IT_CAP1);

        buf01[count01]  = T32N0->MAT1.Word;
        buf01[count00 + 1]  = T32N0->MAT3.Word;
        count01++;

        if (count01 >= 50)
        {
            count01 = 0;
        }
    }
}
/*********************************************************
: void T32N1_IRQHandler(void)
  : T32N1ʱжϺ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T32N1_IRQHandler(void)
{
    if (T32Nx_GetFlagStatus(T32N1, TIM_IT_CAP0) != RESET)
    {
        T32Nx_ClearITPendingBit(T32N1, TIM_IT_CAP0);

        buf10[count10]  = T32N1->MAT0.Word;
        buf10[count10 + 1]  = T32N1->MAT2.Word;
        count10++;

        if (count10 >= 50)
        {
            count10 = 0;
        }
    }

    if (T32Nx_GetFlagStatus(T32N1, TIM_IT_CAP1) != RESET)
    {
        T32Nx_ClearITPendingBit(T32N1, TIM_IT_CAP1);

        buf11[count11]  = T32N1->MAT1.Word;
        buf11[count11 + 1]  = T32N1->MAT3.Word;
        count11++;

        if (count11 >= 50)
        {
            count11 = 0;
        }
    }
}
/*********************************************************
: void T32N2_IRQHandler(void)
  : T32N2ʱжϺ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T32N2_IRQHandler(void)
{
    if (T32Nx_GetFlagStatus(T32N2, TIM_IT_CAP0) != RESET)
    {
        T32Nx_ClearITPendingBit(T32N2, TIM_IT_CAP0);

        buf20[count20]  = T32N2->MAT0.Word;
        buf20[count20 + 1]  = T32N2->MAT2.Word;
        count20++;

        if (count20 >= 50)
        {
            count20 = 0;
        }
    }

    if (T32Nx_GetFlagStatus(T32N2, TIM_IT_CAP1) != RESET)
    {
        T32Nx_ClearITPendingBit(T32N2, TIM_IT_CAP1);

        buf21[count21]  = T32N2->MAT1.Word;
        buf21[count21 + 1]  = T32N2->MAT3.Word;
        count21++;

        if (count21 >= 50)
        {
            count21 = 0;
        }
    }
}
