/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  spi.h
*  :  Liut
*  :  V1.00
*  :  2017/06/26
*  :  SPIģ
*  ע:  HRSDK-GDB-HR8P296 V1.1
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "spi.h"

/*********************************************************
: void SPI_GPIO_Init(void)
  : SPI_GPIOʼ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void SPI_GPIO_Init(void)
{
    GPIO_InitStruType x;
    SPI_InitStruType y;

    GPIO_RegUnLock() ;
    x.GPIO_Func =  GPIO_Func_1;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PDEN = DISABLE;
    x.GPIO_PUEN = DISABLE;
    x.GPIO_OD = DISABLE;
    GPIO_Init(GPIOB, SCK_PIN, &x);      // PB20-SCK,PB21-NSS,PB22-SDI,PB23-SDO    FUN1
    GPIO_Init(GPIOB, SDI_PIN, &x);
    GPIO_Init(GPIOB, SDO_PIN, &x);

    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PDEN = DISABLE;
    x.GPIO_PUEN = DISABLE;
    x.GPIO_OD = DISABLE;
    GPIO_Init(GPIOB, CS_PIN, &x);       //GPIO˿ڳʼ
    GPIO_RegLock();

    y.SPI_Freq = 80000;
    y.SPI_Df = SPI_FallSendRiseRec;
    y.SPI_Mode = SPI_Mode_Master;
    y.SPI_DelayRec = ENABLE;            //ʱʹ
    y.SPI_DelaySend = DISABLE;
    y.SPI_SendDelayPeroid = 0;
    SPI_Init(&y);                       //SPIʼ

    SPI_Enable();
}

/*********************************************************
: void SPI_Ewen(void)
  : EEPROMдʹ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void SPI_Ewen(void)
{
    CS_SET;                             //Ƭѡź
    SPI_SendByte(0x02);

    while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

    SPI_SendByte(0x60);

    while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

    CS_RESET;
}

/*********************************************************
: void SPI_Ewds(void)
  : EEPROMдֹ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void SPI_Ewds(void)
{
    CS_SET;    //cs
    SPI_SendByte(0x02);

    while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

    SPI_SendByte(0x00);

    while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

    CS_RESET;
}

/*********************************************************
: void SPIReadData(uchar addr, uchar *buf, uchar n)
  : SPIݣֽڶ(ѯģʽ)
ֵ: addrַ
        nݸ
ֵ: bufݻ
ֵ: 
**********************************************************/
void SPIReadData(uint8_t addr, uint8_t *buf, uint8_t n)
{
    uint8_t i;

    CS_SET;                                             //cs

    SPI_SendByte(0x03);                                 //ָ

    while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

    SPI_SendByte(addr);                                 //ַ

    while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

    SPI_RecEnable();                                    //ʹܽ

    for (i = 0; i < n; i++)                             //
    {
        while (SPI_GetFlagStatus(SPI_Flag_RB));         //ʱŽ

        SPI_SendByte(0);                                //ͽõʱ

        while (SPI_GetFlagStatus(SPI_Flag_RB) == RESET);

        buf[i] = SPI_RecByte();
    }

    CS_RESET;                                           //cs

    SPI_RecDisable();                                   //ֹ
}

/*********************************************************
: uchar SPIWriteData(uchar memory_addr, uchar *buf, uchar n)
  : SPIдݣֽڱ
ֵ: addrַ
        bufݻ
        nݸ
ֵ: 
ֵ: 
**********************************************************/
void SPIWriteData(uint8_t addr, uint8_t *buf, uint8_t n)
{
    uint8_t i;
    GPIO_InitStruType x;

    GPIO_RegUnLock();
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_PDEN = ENABLE;
    x.GPIO_PUEN = DISABLE;
    x.GPIO_OD = DISABLE;
    GPIO_Init(GPIOB, SDI_PIN, &x);                          //MISOΪ룬жӦ
    GPIO_RegLock();

    SPI_Ewen();                                             //disд
    Delay100us(1);

    for (i = 0; i < n; i++)
    {
        CS_SET;

        SPI_SendByte(0x02);                                 //ָ

        while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

        SPI_SendByte(0x80 | (addr + i));                    //ַ

        while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

        SPI_SendByte(buf[i]);                               //

        while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

        CS_RESET;
        CS_RESET;                                           //Ƭѡ
        CS_SET;

        while ((GPIO_Read(GPIOB) & (uint32_t)0x0400000) == 0); //ȵMISO

        CS_RESET;                                           //ɣcsʧ
    }

    GPIO_RegUnLock();
    x.GPIO_Func = GPIO_Func_1;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PDEN = DISABLE;
    x.GPIO_PUEN = DISABLE;
    x.GPIO_OD = DISABLE;
    GPIO_Init(GPIOB, SDI_PIN, &x);                          //ݿΪspi
    GPIO_RegLock();

    Delay100us(1);
    SPI_Ewds();                                             //д
}

/*********************************************************
: void SPIEraseAll(void)
  : SPIȫƬ0xFF
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void SPIEraseAll(void)
{
    GPIO_InitStruType x;

    GPIO_RegUnLock();
    x.GPIO_Func = GPIO_Func_0;
    x.GPIO_Direction = GPIO_Dir_In;
    x.GPIO_PDEN = ENABLE;
    x.GPIO_PUEN = DISABLE;
    x.GPIO_OD = DISABLE;
    GPIO_Init(GPIOB, SDI_PIN, &x);                      //MISOΪ룬жӦ
    GPIO_RegLock();

    SPI_Ewen();                                         //disд
    Delay100us(1);

    CS_SET;
    SPI_SendByte(0x02);

    while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

    SPI_SendByte(0x40);

    while (SPI_GetFlagStatus(SPI_Flag_IDLE) == RESET);

    CS_RESET;
    CS_RESET;                                          //Ƭѡ
    CS_SET;

    while ((GPIO_Read(GPIOB) & (uint32_t)0x0400000) == 0); //ȵMISO

    CS_RESET;                                           //ɣcsʧ

    GPIO_RegUnLock();
    x.GPIO_Func = GPIO_Func_1;
    x.GPIO_Direction = GPIO_Dir_Out;
    x.GPIO_PDEN = DISABLE;
    x.GPIO_PUEN = DISABLE;
    x.GPIO_OD = DISABLE;
    GPIO_Init(GPIOB, SDI_PIN, &x);                      //ݿΪspi
    GPIO_RegLock();

    Delay100us(1);
    SPI_Ewds();                                         //д
}

