/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  pwm.c
*  :  Liut
*  :  V1.00
*  :  2017/06/26
*  :  PWMģ
*  ע:  HRSDK-GDB-HR8P296 V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "pwm.h"

/*********************************************************
: void User_T32N1_PWMInit(void)
  : T32N1ʱʼPWM
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void User_T32N1_PWMInit(void)
{
    TIM_BaseInitStruType x;

    x.TIM_ClkS = TIM_ClkS_PCLK;                 //ѡʱӣPclk
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_PWM ;                 //ΪPWMģʽ
    T32Nx_BaseInit(T32N1, &x);

    T32N1_PwmOut1_Enable();                     //ʹܶ˿1
    T32Nx_MAT2Out1Config(T32N1, TIM_Out_High);  //ƥ2
    T32Nx_MAT3Out1Config(T32N1, TIM_Out_Low);   //ƥ3

    T32Nx_SetPREMAT(T32N1, 5);                  //ԤƵ1:7
    T32Nx_SetMAT2(T32N1, 3000);                 //ռձ
    T32Nx_SetMAT3(T32N1, 6000);                 //Ƶ

    T32Nx_MAT2ITConfig(T32N1, TIM_Go_Int);      //ƥ2
    T32Nx_MAT3ITConfig(T32N1, TIM_Clr_Int);     //ƥ30

    T32Nx_ITConfig(T32N1, TIM_IT_MAT2, DISABLE);  //ѡǷʹж
    T32Nx_ITConfig(T32N1, TIM_IT_MAT3, DISABLE);
    NVIC_Init(NVIC_T32N1_IRQn, NVIC_Priority_1, DISABLE);     //򿪻رж
    T32N1_Enable();                             //ʹܶʱ
}

/*********************************************************
: void PWMOutput(uint32_t temp)
  : T32N1 PWMƵʣռձȹ̶Ϊ50%ʹ
ֵ: Ƶֵ
ֵ: 
ֵ: 
**********************************************************/
void PWMOutput(uint16_t temp)
{
    T32Nx_SetMAT2(T32N1, temp / 2); //͵ƽʱ
    T32Nx_SetMAT3(T32N1, temp);     //ʱ
    T32Nx_SetCNT(T32N1, 0);         //úһҪCNT¼
}
