/*
----------------------------------------------------------------------
File   : DEFAULT.ld
Purpose: Link file for DEFAULT FLASH
-------- END-OF-HEADER -----------------------------------------------
*/

OUTPUT_FORMAT("elf32-littlearm","elf32-littlearm","elf32-littlearm")
OUTPUT_ARCH(arm)
ENTRY(__vector)

/*********************************************************************
*
*       Define stack sites here
*/


MEMORY
{
  FLASH1 (rx)  : ORIGIN = 0x0, LENGTH = 0x00020000
  FLASH2 (rx)  : ORIGIN = 0x0, LENGTH = 0x0
  FLASH3 (rx)  : ORIGIN = 0x0, LENGTH = 0x0

  RAM1   (wx)  : ORIGIN = 0x20000000, LENGTH = 0x00003000
  RAM2   (wx)  : ORIGIN = 0x20000000, LENGTH = 0x0
  RAM3   (wx)  : ORIGIN = 0x20000000, LENGTH = 0x0

}

SECTIONS
{
  .text1 : 
  {
    KEEP( *(.vectors));
    *(.text*);
    . = ALIGN(4);
    KEEP(*(.init));
    KEEP(*(.fini));
    . = ALIGN(4);
    *(.rodata);
    . = ALIGN(4);
    *(.rodata*);
    . = ALIGN(4);
    *(.glue_7t);
    . = ALIGN(4);
    *(.glue_7);
    . = ALIGN(4);
    etext = .;
  } > FLASH1
  
  . = ALIGN(4);
  _etext = . ;
  PROVIDE (etext = .);
  _sidata = .;
  


  .data : AT (_etext)
  {
    PROVIDE (__data_start__ = .);
    PROVIDE (_data = .) ;
    *(.data*)
    . = ALIGN(4);
    PROVIDE (__data_end__ = .);
  } > RAM1

  _my_rom_end  = _etext + SIZEOF(.data);

  . = ALIGN(4);
  _edata = . ;
  PROVIDE (edata = .);

  .bss : AT(_edata)
  {
    PROVIDE (__bss_start__ = .);
    *(.bss*)
    *(COMMON)
    . = ALIGN(4);
    PROVIDE (__bss_end__ = .);

    . = ALIGN(256);

  } > RAM1

  _ram_current = ALIGN(4);
   .heap : AT(_ram_current)
  {
    PROVIDE (__heap_start = .);
    *(.heap*)
    PROVIDE (__heap_end__ = .);
  } > RAM1 

  _ram_current = ALIGN(4);
  .stack : AT(_ram_current)
  {
    PROVIDE (__stack_start = .);
    *(.stack)
    PROVIDE (__stack_end__ = .);
  } > RAM1 

  .ram1_text : AT (_my_rom_end) 
  {
    . = ALIGN(4);
    _my_ram1_start = .;

  } > RAM1 
  _my_ram1_size = SIZEOF(.ram1_text);
  
  .ram2_text : AT (_my_rom_end + _my_ram1_size) 
  {
    . = ALIGN(4);
    _my_ram2_start = .;

  } > RAM2 
  _my_ram2_size = SIZEOF(.ram2_text);
  
  .ram3_text : AT (_my_rom_end + _my_ram1_size + _my_ram2_size) 
  {
    . = ALIGN(4);
    _my_ram3_start = .;

  } > RAM3 
  _my_ram3_size = SIZEOF(.ram3_text);

}
