/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:  main.c
*  :  Liut
*  :  V1.00
*  :  2017/06/24
*  :  IICʾͨ400K
          IICշʹɨ跽ʽ--EEPROMͺţ24C01ʵַΧ0x00~0x7F
          ѡַдLEDʾ1ֽڵַ+1ֽݣ
         1K4ַͰֽ+1ͬʱǰ
         2K3ַֽ߰+1ͬʱǰ
         3K2д=ǰַ
         4K1д=0x00
         5K5ȫƬ
*  ע:  HRSDK-GDB-HR8P296 V1.0
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"

int main(void)
{
    uint8_t key;
    uint8_t com;
    uint8_t i;

    SystemClockConfig();                                                //ʱ
    DeviceClockAllEnable();                                             //ʱ

    SysTickInit();
    T16N3Init();
    LEDInit();
    KeyInit();
    IICMasterInit();

    com = 0;                                                            //ʾλĳʼֵcom0

    g_addr_h = 0x00;                                                    //ʼַ
    g_addr_l = 0x00;
    g_addr = (g_addr_h << 4) + g_addr_l;
    g_data_h = 0x00;                                                    //ʼ
    g_data_l = 0x00;
    g_data = (g_data_h << 4) + g_data_l;

    IICMasterReadData(SLAVE_ADDR, g_addr, g_rbuf, 1);                   //1ֽEEPROM

    while (1)
    {
        if (g_2ms_flag == 1)
        {
            g_2ms_flag = 0;
            LEDDisplayData(com, g_led_buf[com]);
            com++;

            if (com > 3)
                com = 0;
        }

        if (g_10ms_flag == 1)
        {
            g_10ms_flag = 0;

            key = KeyGetValue();

            switch (key)
            {
                case 4:                                             //K4ַͰֽ+1ͬʱǰ
                    g_addr_l += 0x01;

                    if (g_addr_l > 0x0F)
                        g_addr_l = 0;

                    g_addr = (g_addr_h << 4) + g_addr_l;
                    IICMasterReadData(SLAVE_ADDR, g_addr, g_rbuf, 1);   //1ֽEEPROM
                    break;

                case 3:                                             //K3ַֽ߰+1ͬʱǰ
                    g_addr_h += 0x01;

                    if (g_addr_h > 0x07)                                //EEPROMַΧ0x00~0x7F
                        g_addr_h = 0;

                    g_addr = (g_addr_h << 4) + g_addr_l;
                    IICMasterReadData(SLAVE_ADDR, g_addr, g_rbuf, 1);   //1ֽEEPROM
                    break;

                case 2:                                                 //K2д=ǰַ
                    g_wbuf[0] = g_addr;
                    IICMasterWriteData(SLAVE_ADDR, g_addr, g_wbuf, 1);  //д1ֽEEPROM
                    Delay100us(100);
                    IICMasterReadData(SLAVE_ADDR, g_addr, g_rbuf, 1);   //1ֽEEPROM
                    break;

                case 1:                                                 //K1д=0x00
                    g_wbuf[0] = 0x00;
                    IICMasterWriteData(SLAVE_ADDR, g_addr, g_wbuf, 1);  //д1ֽEEPROM
                    Delay100us(100);
                    IICMasterReadData(SLAVE_ADDR, g_addr, g_rbuf, 1);   //1ֽEEPROM
                    break;

                case 5:                                                 //K5ȫƬ
                    g_addr = 0x00;

                    for (i = 0; i < 16; i++)                            //ܹ16ҳ
                    {
                        IICMasterErasePage(SLAVE_ADDR, g_addr);         //128ֽEEPROMռ䣬д0xFF
                        Delay100us(100);
                        g_addr += 8;
                    }

                    g_addr_h = 0x00;                                    //ַ
                    g_addr_l = 0x00;
                    g_addr = 0x00;
                    IICMasterReadData(SLAVE_ADDR, g_addr, g_rbuf, 1);   //1ֽEEPROMݣʾ
                    break;

                default:
                    break;
            }

            g_data_l = g_rbuf[0] & 0x0F;                                //¶
            g_data_h = g_rbuf[0] >> 4;

            g_led_buf[0] = g_addr_h;                                    //ʾ
            g_led_buf[1] = g_addr_l;
            g_led_buf[2] = g_data_h;
            g_led_buf[3] = g_data_l;
        }
    }
}
