/***************************************************************
 *Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd
 *ļ  lib_lcd.c
 *  ߣ  JiangYz
 *    V1.00
 *  ڣ  2016/02/02
 *    LCDģ⺯
 *  ע   HR8P296оƬ
 ѧϰʾʹãûֱôķջеκηΡ
 ***************************************************************/

#include "lib_lcd.h"
#include "system_HR8P296.h"
//#include "Lib_Timer.h"


/***************************************************************
  LCD_Init
    ʼLCDģ
  ֵʼýṹַ,SELx:ѡLCD
  ֵ
  ֵɹʧ
 ***************************************************************/

ErrorStatus LCD_Init(LCD_InitStruType *LCD_InitStruct, LCDSEL_TYPE SELx)
{
    if (LCD_InitStruct->LCD_PRS > 63)
    {
        return ERROR;
    }
    else
    {

        LCDC->CON0.PRS   = LCD_InitStruct->LCD_PRS;  // LCDʱԴƵѡλ 0~63
    }

    switch (SELx)
    {
        case Sel_0:                                           //ѡSEL0
            LCDC->SEL0.SEG  = LCD_InitStruct->LCD_SEG0; //SEL0ʹ
            break;

        case Sel_1:                                      //ѡSEL1
            if (LCD_InitStruct->LCD_SEG1 > 0x00FFFFFF)
            {
                return ERROR;
            }
            else
            {
                LCDC->SEL1.SEG  = LCD_InitStruct->LCD_SEG1;  // SEL1ʹ

            }

            break;

        case Sel_All:                                  //ѡSEL0+SEL1
            if (LCD_InitStruct->LCD_SEG1 > 0x00FFFFFF)
            {
                return ERROR;
            }
            else
            {
                LCDC->SEL0.SEG  = LCD_InitStruct->LCD_SEG0;
                LCDC->SEL1.SEG  = LCD_InitStruct->LCD_SEG1;

            }

    }

    LCDC->CON0.COMS = LCD_InitStruct->LCD_Coms;       // ѡλ

    LCDC->CON0.FLIK  = LCD_InitStruct->LCD_LcdFlik;   // LCDʾ˸ʹλ

    LCDC->CON0.WFS  = LCD_InitStruct->LCD_LcdWFS ;     // LCDѡλ

    LCDC->CON0.BIAS  = LCD_InitStruct->LCD_Bias;      // LCDƫѡ

    LCDC->CON0.RS  = LCD_InitStruct->LCD_RS;          // LCDڲƫõѡ

    LCDC->CON0.BVS  = LCD_InitStruct->LCD_Grayscale;  // LCDʾҶȿ

    LCDC->CON0.BIAS_SEL = LCD_InitStruct->LCD_BIAS_SEL; //ڲƫõѹʹλ

    return SUCCESS;
}

/***************************************************************
  LCD_ITConfig
    LCDж
  ֵLCD_ITҪõж  NewStateʹܻر
  ֵ
  ֵ
 ***************************************************************/
void LCD_ITConfig(LCD_TYPE_IE LCD_IT, TYPE_FUNCEN NewState)
{
    if (NewState != DISABLE)
    {
        LCDC->IE.Word |= (uint32_t)LCD_IT;
    }
    else
    {
        LCDC->IE.Word &= ~((uint32_t)LCD_IT);
    }
}

/***************************************************************
  LCD_GetRFITStatus
    ȡLCDˢжϱ־
  ֵ
  ֵ
  ֵSETжϣ/RESETжϣ
 ***************************************************************/
ITStatus LCD_GetRFITStatus(void)
{
    ITStatus bitstatus = RESET;

    /* жϱ־λ */
    if ((LCDC->IF.RFIF != (uint32_t)RESET))
    {

        bitstatus = SET;   //תɣж
    }
    else
    {

        bitstatus = RESET; //ж
    }

    return  bitstatus;
}

/***************************************************************
  LCD_GetOFFITStatus
    ȡLCDرжϱ־
  ֵ
  ֵ
  ֵSETжϣ/RESETжϣ
 ***************************************************************/
ITStatus LCD_GetOFFITStatus(void)
{
    ITStatus bitstatus = RESET;

    /* жϱ־λ */
    if ((LCDC->IF.OFFIF != (uint32_t)RESET))
    {
        bitstatus = SET;    //תɣж
    }
    else
    {
        bitstatus = RESET;  //ж
    }

    return  bitstatus;
}

/***************************************************************
  LCD_GrayscaleConfig
    LCDҶѡ
  ֵҶȵѹֵ
  ֵ
  ֵ
 ***************************************************************/
void LCD_GrayscaleConfig(LCD_TYPE_BVS LCD_Grayscale)
{
    /* LCDʾҶȿ */
    LCDC->CON0.BVS  = LCD_Grayscale;
}

/***************************************************************
  LCD_FlickerTimeConfig
    ˸ʱ
  ֵOn_Time˸ʱ/0.25s  Off_TimeϨʱ/0.25s
  ֵ
  ֵɹʧ
 ***************************************************************/
ErrorStatus LCD_FlickerTimeConfig(uint8_t On_Time, uint8_t Off_Time)
{
    LCDC->FLKT.TON  = On_Time;    //LCDʱ

    LCDC->FLKT.TOFF   = Off_Time;   //LCDϨʱ
    return SUCCESS;
}

/***************************************************************
  LCD_PixelWriteByte
    LCDؼĴ һд8bit
  ֵLCD_DD:LCDؼĴ  nByteؼĴĵڼֽ  LCD_dataӦ
  ֵ
  ֵɹʧ
 ***************************************************************/
ErrorStatus  LCD_PixelWriteByte(LCD_TYPE_PIXEL LCD_DD, LCD_DD_BYTE nByte, uint8_t LCD_data)
{
    if (LCD_DD > 13 || nByte > 3)
    {
        return ERROR;
    }

    switch (LCD_DD)
    {
        case LCD_Pixel_LCDD0:
            LCDC->D0.LCDD0 = (LCDC->D0.LCDD0 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8)); //8bitд뵽LCDؼĴĵnByteֽ
            break;

        case LCD_Pixel_LCDD1:
            LCDC->D1.LCDD1 = (LCDC->D1.LCDD1 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD2:
            LCDC->D2.LCDD2 = (LCDC->D2.LCDD2 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD3:
            LCDC->D3.LCDD3 = (LCDC->D3.LCDD3 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD4:
            LCDC->D4.LCDD4 = (LCDC->D4.LCDD4 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD5:
            LCDC->D5.LCDD5 = (LCDC->D5.LCDD5 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD6:
            LCDC->D6.LCDD6 = (LCDC->D6.LCDD6 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD7:
            LCDC->D7.LCDD7 = (LCDC->D7.LCDD7 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD8:
            LCDC->D8.LCDD8 = (LCDC->D8.LCDD8 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD9:
            LCDC->D9.LCDD9 = (LCDC->D9.LCDD9 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD10:
            LCDC->D10.LCDD10 = (LCDC->D10.LCDD10 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD11:
            LCDC->D11.LCDD11 = (LCDC->D11.LCDD11 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD12:
            LCDC->D12.LCDD12 = (LCDC->D12.LCDD12 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        case LCD_Pixel_LCDD13:
            LCDC->D13.LCDD13 = (LCDC->D13.LCDD13 & (~(0X000000FFul << (nByte * 8)))) | (((uint32_t)LCD_data) << (nByte * 8));
            break;

        default:
            return  ERROR;
    }

    return SUCCESS;
}


/***************************************************************
  LCD_PixelWriteHalfWord
    LCD һд16bit
  ֵLCD_DD    ؼĴѡ
  nHalfWord     /6bitѡ
  LCD_data      д16bit
  ֵ
  ֵSUCCESS ɹ
  ERROR ʧ
 ***************************************************************/
ErrorStatus  LCD_PixelWriteHalfWord(LCD_TYPE_PIXEL LCD_DD, LCD_DD_HALFWORD nHalfWord, uint16_t LCD_data)
{
    if (LCD_DD > 13 || nHalfWord > 1)
    {
        return ERROR;
    }

    switch (LCD_DD)
    {
        case LCD_Pixel_LCDD0:
            LCDC->D0.LCDD0 = (LCDC->D0.LCDD0 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16)); //16bitд뵽LCDؼĴĸ16λ/16λ
            break;

        case LCD_Pixel_LCDD1:
            LCDC->D1.LCDD1 = (LCDC->D1.LCDD1 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD2:
            LCDC->D2.LCDD2 = (LCDC->D2.LCDD2 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD3:
            LCDC->D3.LCDD3 = (LCDC->D3.LCDD3 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD4:
            LCDC->D4.LCDD4 = (LCDC->D4.LCDD4 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD5:
            LCDC->D5.LCDD5 = (LCDC->D5.LCDD5 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD6:
            LCDC->D6.LCDD6 = (LCDC->D6.LCDD6 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD7:
            LCDC->D7.LCDD7 = (LCDC->D7.LCDD7 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD8:
            LCDC->D8.LCDD8 = (LCDC->D8.LCDD8 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD9:
            LCDC->D9.LCDD9 = (LCDC->D9.LCDD9 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD10:
            LCDC->D10.LCDD10 = (LCDC->D10.LCDD10 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD11:
            LCDC->D11.LCDD11 = (LCDC->D11.LCDD11 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD12:
            LCDC->D12.LCDD12 = (LCDC->D12.LCDD12 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        case LCD_Pixel_LCDD13:
            LCDC->D13.LCDD13 = (LCDC->D13.LCDD13 & (~(0X0000FFFFul << (nHalfWord * 16)))) | (((uint32_t)LCD_data) << (nHalfWord * 16));
            break;

        default:
            return  ERROR;
    }

    return SUCCESS;
}

/***************************************************************
  LCD_PixelWriteWord
    LCD һд32bit
  ֵLCD_DD    ؼĴѡ
  LCD_data      д32bit
  ֵ
  ֵSUCCESS ɹ
  ERROR ʧ
 ***************************************************************/
ErrorStatus  LCD_PixelWriteWord(LCD_TYPE_PIXEL LCD_DD, uint32_t LCD_data)
{
    if (LCD_DD > 13)
    {
        return ERROR;
    }

    switch (LCD_DD)
    {
        case LCD_Pixel_LCDD0:
            LCDC->D0.LCDD0 = (uint32_t)LCD_data; //32bitд뵽LCDؼĴ
            break;

        case LCD_Pixel_LCDD1:
            LCDC->D1.LCDD1 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD2:
            LCDC->D2.LCDD2 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD3:
            LCDC->D3.LCDD3 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD4:
            LCDC->D4.LCDD4 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD5:
            LCDC->D5.LCDD5 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD6:
            LCDC->D6.LCDD6 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD7:
            LCDC->D7.LCDD7 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD8:
            LCDC->D8.LCDD8 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD9:
            LCDC->D9.LCDD9 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD10:
            LCDC->D10.LCDD10 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD11:
            LCDC->D11.LCDD11 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD12:
            LCDC->D12.LCDD12 = (uint32_t)LCD_data;
            break;

        case LCD_Pixel_LCDD13:
            LCDC->D13.LCDD13 = (uint32_t)LCD_data;
            break;

        default:
            return  ERROR;
    }

    return SUCCESS;
}



/*************************END OF FILE**********************/
