/***************************************************************
 *Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd
 *ļ  lib_wdt.c
 *  ߣ  JiangYz
 *    V1.00
 *  ڣ  2016/02/04
 *    Źģ⺯
 *  ע   HR8P296оƬ
 ѧϰʾʹãûֱôķջеκηΡ
 ***************************************************************/


#ifndef __LIBWDT_H__
#define __LIBWDT_H__

#include "HR8P296.h"

#include "type.h"
/* WDTʱѡ */
typedef enum {
	WDT_CLOCK_PCLK = 0x0,	//PCLK
	WDT_CLOCK_WDT  = 0x1,	//WDTʱԴ32kHz
} WDT_TYPE_CLKS;

/* ʼṹ */
typedef struct {
	uint32_t WDT_Tms;		//ʱʱ䣬λms 
	TYPE_FUNCEN WDT_IE;		//жʹ
	TYPE_FUNCEN WDT_Rst;	//λʹ
	WDT_TYPE_CLKS WDT_Clock;//ʱѡ
} WDT_InitStruType;

#define WDT_RegUnLock()		(WDT->LOCK.Word = 0x1ACCE551)
#define WDT_RegLock()		(WDT->LOCK.Word = 0x0)

#define WDT_Enable()		{WDT_RegUnLock();WDT->CON.EN = 1;WDT_RegLock();}
#define WDT_Disable()		{WDT_RegUnLock();WDT->CON.EN = 0;WDT_RegLock();}

#define WDT_Clear()	    	{WDT_RegUnLock();WDT->INTCLR.INTCLR=0;WDT_RegLock();}

#define WDT_ITEnable()		{WDT_RegUnLock();WDT->CON.IE = 1;WDT_RegLock();}
#define WDT_ITDisable()		{WDT_RegUnLock();WDT->CON.IE = 0;WDT_RegLock();}

#define WDT_RstEnable()		{WDT_RegUnLock();WDT->CON.RSTEN = 1;WDT_RegLock();}
#define WDT_RstDisable()	{WDT_RegUnLock();WDT->CON.RSTEN = 0;WDT_RegLock();}

#define WDT_CLOCK_PCLK()	{WDT_RegUnLock();WDT->CON.CLKS = 1;WDT_RegLock();}
#define WDT_CLOCK_WDT()		{WDT_RegUnLock();WDT->CON.CLKS = 0;WDT_RegLock();}


void WDT_Init(WDT_InitStruType *WDT_InitStruct);
void WDT_SetReloadValue(uint32_t Value);
uint32_t WDT_GetValue(void);
FlagStatus WDT_GetFlagStatus(void);

#endif
