/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	main.c
*  :	WangMX
*  :	V1.00
*  :	2014/10/10
*  :	AMCUMCU
*  ע:    HRSDK-GMB-017P169

			| SW1  SW2  SW3  SW4 |	
			˿| PB7  PB6  PB5  PB4 |            
			----|--------------------|-------------------------------
				| OFF  OFF  N/A	 OFF |			   
				| ON   OFF  N/A	 X   | PA350Hz50%ռձ      
				| ON   ON   N/A	 X   | PA360Hz50%ռձ         
				| X	   X    N/A  ON  | I2CͨѶ(PA4-SSCL/PA5-SSDA)      

ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"
#include "i2cm.h"

/*********************************************************
:	void main()
  :	
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main()
{
	RAMClear();			 //RAM
	MCUInit();			 //ʼMCU
	I2CMasterInit();	 //ʼI2CM

	mode = 0;			 //㵱ǰģʽ
	g_addr = 0x01;		 //ʼI2CͨѶƬڵַ

	while (1)
	{
		clr_wdt();
		if (SW4 == ON)
		{
			if(g_500ms_flag == 1)                 
			{
				g_500ms_flag = 0;
				I2CMasterReadData(SLAVE_ADDR, g_addr, g_rbuf, 1);	//1ֽEEPROM			
				g_wbuf[0] = g_rbuf[0];
				Delay500us(20);										//ʱ10ms					
				I2CMasterWriteData(SLAVE_ADDR, g_addr, g_wbuf, 1);	//д1ֽEEPROM
				PA0 = ~PA0;			//˸LED 
			}				
		}

		if ((SW1 == ON) && (SW2 == ON))	//SW1SW2򿪣60Hz
		{
			if (g_8ms_flag == 1)		
			{
				g_8ms_flag = 0;
				PA1 = ~PA1;			//60Hz 
				PA0 = ~PA0;			//LED
			}
		}

		if ((SW1 == ON) && (SW2 == OFF))//SW1򿪣SW2رգ50Hz
		{
			if (g_10ms_flag == 1)		
			{
				g_10ms_flag = 0;
				PA1 = ~PA1;			//50Hz 
				PA0 = ~PA0;			//LED
			}
		}

		if ((SW1 == OFF) && (SW2 == OFF) && (SW4 == OFF))
		{
			PA0 = 1;				//ϨLED 
		}
	}
}

/*********************************************************
:	void MCUInit(void) 
  :	ϵͳʼӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void MCUInit(void) 
{
	//оƬϵͳʱӣĬΪINTOSCIO 4MHzģʽ
	PA = 0x30;		//õƽ
	PB = 0x00;
	PC = 0x00;

	PAT = 0x00;		//÷01
	PBT = 0xFF;
	PCT = 0xFF;	

	PAPU = 0xFF;	//0ֹ1ʹ
	PBPU = 0xF0;	
	PCPU = 0x00;
	
	ANSL = 0xFF;	//AIN0~AIN6ΪI/O0ģ⣻1-
	ANSH = 0xFF;	//AIN7~AIN13ΪI/O0ģ⣻1-

	T8NC = 0x8E;	//ԤƵƵΪ1:128
	T8N	 = 224;		//(256-T8N)*0.25*2*128=2ms @ 4MHz.2T

	T8NIE = 1;		//ʹT8Nж
	GIE = 1;		//ʹȫж
}

/*********************************************************
:	void RAMClear(void) 
  :	ͨRAMӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void RAMClear(void)
{
	__asm
	{				//ַ0x0000~0x03FF
		MOVI 0x00			
		MOVA IAAH 
		MOVI 0x00			
		MOVA IAAL 
		CLR	 IAD 
		INC	 IAAL,1
		JBS	 PSW,C
		GOTO $-3
		INC IAAH,1
		JBS IAAH,2
		GOTO $-6
	}
}

