/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	i2cm.c
*  :	WangMX
*  :	V1.00
*  :	2014/10/10
*  :	AMCUMCUI2Cģģ⣩
*  ע:    HRSDK-GMB-017P169
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "i2cm.h"

/*********************************************************
:	void I2CMasterInit(void)
  :	I2CMʼӳ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void I2CMasterInit(void)
{
	SCL_H;			//ʱ
	SDA_H;			//
	SCL_OUT;		//ʱ߷
	SDA_OUT;		//߷
}

/*********************************************************
:	uchar I2CMasterWriteData(uchar slave_addr, uchar memory_addr, uchar *buf, uchar n)
  :	I2CMд
ֵ: slave_addrӻַ
		memory_addrƬڵַ
		bufݻ
		nݸ
ֵ: 
ֵ: 0TRUE
		1FALSE
**********************************************************/
uchar I2CMasterWriteData(uchar slave_addr, uchar memory_addr, uchar *buf, uchar n)
{
	uchar i;	

	I2CMasterStart();					//ʼλ
	I2CMasterWriteByte(slave_addr);		//ʹӻַд
	if (I2CMasterWaitAck() == NACK)		//жӦǷȷ
	{
		I2CMasterStop();				//ֹͣλ
		return FALSE;					//Ӧ
	}
	I2CMasterWriteByte(memory_addr);	//Ƭڵַ
	if (I2CMasterWaitAck() == NACK)		//жӦǷȷ
	{
		I2CMasterStop();				//ֹͣλ
		return FALSE;					//Ӧ
	}

	Delay500us(10);		
	for (i=0; i<n; i++)
	{
		I2CMasterWriteByte(buf[i]); 	// 
		if (I2CMasterWaitAck() == NACK)	//жӦǷȷ
		{
			I2CMasterStop();			//ֹͣλ
			return FALSE;				//Ӧ
		}
	}
	I2CMasterStop();					//ֹͣλ
	return TRUE;						//ȷ
}

/*********************************************************
:	uchar I2CMasterReadData(uchar slave_addr, uchar memory_addr, uchar *buf, uchar n)
  :	I2CM
ֵ: slave_addrӻַ
		memory_addrƬڵַ
		nݸ
ֵ: bufݻ
ֵ: 0TRUE
		1FALSE
**********************************************************/
uchar I2CMasterReadData(uchar slave_addr, uchar memory_addr, uchar *buf, uchar n)
{
	uchar i;
		
	I2CMasterStart();					//ʼλ
	I2CMasterWriteByte(slave_addr);		//ʹӻַд
	if (I2CMasterWaitAck() == NACK)		//жӦǷȷ
	{
		I2CMasterStop();				//ֹͣλ
		return FALSE;					//Ӧ
	}
	I2CMasterWriteByte(memory_addr);	//Ƭڵַ
	if (I2CMasterWaitAck() == NACK)		//жӦǷȷ
	{
		I2CMasterStop();				//ֹͣλ
		return FALSE;					//Ӧ
	}

	I2CMasterStart();					//ʼλ
	I2CMasterWriteByte(slave_addr+1);	//ʹӻַ
	if (I2CMasterWaitAck() == NACK)		//жӦǷȷ
	{
		I2CMasterStop();				//ֹͣλ
		return FALSE;					//Ӧ
	}

    SDA_IN;		//debug, лΪ(治ʱ,ɾȥ)
	Delay500us(10);
	for (i=0; i<n-1; i++)
	{
        buf[i] = I2CMasterReadByte(); 	//
		I2CMasterSendAck();				//ACK
	}
    buf[i] = I2CMasterReadByte(); 		//һֽ
	I2CMasterSendNack();				//NACK
	I2CMasterStop();					//ֹͣλ
	return TRUE;						//ȷ
}

/*********************************************************
:	void I2CMasterStart(void)
  :	I2CMʼλ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void I2CMasterStart(void)				
{
    SDA_H; 
    SCL_H; 
    SCL_OUT;
    SDA_OUT;
    Delay500us(2);    
    SDA_L;			//
    Delay500us(2); 
    SCL_L;  		//ʱ       
}

/*********************************************************
:	void I2CMasterStop(void)
  :	I2CMֹͣλ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void I2CMasterStop(void)	
{
    SCL_L; 
    SDA_L; 
    Delay500us(2);
    SCL_H;			//ʱ
    Delay500us(2); 
    SDA_H;      	//
}

/*********************************************************
:	uchar I2CMasterWaitAck(void)
  :	I2CMȴӻACK
ֵ: 
ֵ: 
ֵ: 0ACK
		1NACK 
**********************************************************/
uchar I2CMasterWaitAck(void)	
{
    uchar wait_time, ack_state;
 
    SDA_H; 
    SDA_IN;					//лΪ
    Delay500us(4);	
    SCL_H;					//ʱΪ
    Delay500us(6);  

	wait_time = 10;			//趨ʱʱ
	ack_state = ACK;
    while (SDA == 1)		//ȴACKźţSDAͣ
    {
    	if(wait_time == 0)	//жϳʱ
	    {	      	
		    ack_state = NACK;
		    break;
		}
		wait_time--;
	}
    SCL_L;					//ʱΪ
    Delay500us(2); 
    SDA_OUT;  				//лΪ
	return ack_state;		//ֵACK=0NACK=1
}

/*********************************************************
:	void I2CMasterSendAck(void)
  :	I2CMACK
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void I2CMasterSendAck(void)			
{
    SDA_L;					//Ϊ
    Delay500us(2);
    SCL_H;
    Delay500us(2);
    SCL_L;
}

/*********************************************************
:	void I2CMasterSendNack(void)
  :	I2CMNACK
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void I2CMasterSendNack(void)	
{
	SDA_H;					//Ϊ
	Delay500us(2);
	SCL_H;
	Delay500us(2);
	SCL_L;
}

/*********************************************************
:	void I2CMasterWriteByte(uchar ch)
  :	I2CMдֽʱ
ֵ: chֽ
ֵ: 
ֵ:  
**********************************************************/
void I2CMasterWriteByte(uchar ch)	//I2CMдֽ
{
	uchar i, send_ch;  
	i = 8;					//λ8
	send_ch = ch;

	do
	{
		SCL_L;				//ʱΪ
		Delay500us(1);
		if (send_ch & 0x80)	//ȸλλ 
		{
			SDA_H;			
		}
		else 
		{
			SDA_L;
		}
		send_ch <<= 1;		//
		Delay500us(2);
		SCL_H;				//ʱΪ
		Delay500us(2);
		i--;
	}while (i > 0);			//жϷ8λݽ	
	SCL_L;					//ʱ
	SDA_IN;					//лΪ
}

/*********************************************************
:	uchar I2CMasterReadByte(void)
  :	I2CMֽʱ
ֵ: 
ֵ: 
ֵ: յֽ 
**********************************************************/
uchar I2CMasterReadByte(void)	
{
	uchar i, rec_ch;  
	i = 8;					//λ8
	rec_ch = 0;				//ֵ0
  
	//SDA_H;				//
	SDA_IN;					//лΪ
	do
	{
	    rec_ch <<= 1;		//
	    SCL_L; 				//ʱΪ
	    Delay500us(2);
	    SCL_H;				//ʱΪ
	    Delay500us(2);
		if (SDA == 1)
		{
	    	rec_ch |= 0x01;    		
		}
		i--;
	}while (i > 0);			//жϷ8λݽ	
	SCL_L;
	SDA_OUT;				//лΪ
	return rec_ch; 
}

/*********************************************************
:	void Delay500us(uchar time)
  :	ʱӳ򣬵λ500us
ֵ: timeʱ
ֵ: 
ֵ: 
**********************************************************/
void Delay500us(uchar time)		
{
    uchar i,j;
	clr_wdt();
    for (i=0; i<time; i++)
    {
        nop();	      //0.5us @4MHz,2T
        nop();	   
		for (j=0; j<0x70; j++)		//500us
		{
			nop();   
			nop();
		}		 	      
    }
}

