/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	adc.c
*  :	XieYF
*  :	V1.20
*  :	2014/11/25
*  :	ADC
*  ע:    HR7P169/170
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#include <string.h>
unsigned char g_adc_value_h;
unsigned char g_adc_value_l;
unsigned int ADCRH1;    //ADת
unsigned int ADCRH2;    //ADת


//4MHz,һָΪ0.5us
/***********************************************************
*    void Delay_nus(u16 nus)      
*  ʱn us,ȷ           
*  n us                                
*ֵ                    
*ú  
*  
*޶Ҫ  2014.01.07 V1.0                         
***********************************************************/  
void Delay_nus(unsigned int nus)
{
    unsigned int i;
    for(i=0;i<nus;i++);
}

/***********************************************************
*    void init_io(void)  
*  I/Oʼ           
*                                  
*ֵ                   
*ú  
*  
*޶Ҫ  2014.01.07 V1.0                         
***********************************************************/  
void init_io(void)
{
    ANSL = 0x00;                  //AIN0~6Ϊģ˿
    ANSH = 0x00;                  //AIN7~13Ϊģ˿ 
}

/***********************************************************
*    void  init_adc(void)   
*  adcʼ           
*                                  
*ֵ                   
*ú  
*  
*޶Ҫ  2014.01.07 V1.0                         
***********************************************************/ 
void init_adc(void)
{
    ANSL = 0x00;                  //AIN0~6Ϊģ˿0x5f ain5
    ANSH = 0x00;                  //AIN7~13Ϊģ˿  0xff 
    ADCTST = 0x00;                //ADתٶΪ
    ADCCL = 0x05;                 //A/Dת,ӲƲ
    ADCCH = 0x48;                 //ADCʱΪ8ADCʱӣֵλ룬A/DתʱƵΪFosc/16οѹΪVDD
}

/***********************************************************
*    void convert_adc(void)  
*  adcת           
*                                  
*ֵ                    
*ú  
*  
*޶Ҫ  2014.01.07 V1.0                         
***********************************************************/ 
void convert_adc(void)
{
    ADTRG = 1;
    while(ADTRG);
    ADIF = 0;
    g_adc_value_h = ADCRH;
    g_adc_value_l = ADCRL;
    ADEN = 0;                       //رAD
}

/***********************************************************
*    void clear_ram(void)    
*  ramȫ           
*                                  
*ֵ                   
*ú  MCUʼʱ
*  
*޶Ҫ  2014.01.07 V1.0                         
***********************************************************/  
void clear_ram(void) 
{
    __asm 
    { 
	     CLR   IAAL;
          CLR   IAAH;
	     CLR   IAD;
	     INC   IAAL,1;
	     JBS   PSW,C
	     GOTO  $-3;
	     INC   IAAH,1;
	     JBS   IAAH,2
	     GOTO  $-6;
    } 
}

/***********************************************************
*    void  init_mcu(void)   
*  MCUʼʱ            
*                                  
*ֵ                   
*ú  
*  
*޶Ҫ  2014.01.07 V1.0                         
***********************************************************/  
void  init_mcu(void)
{
	clear_ram();  		         //ʼRAM
    INTG = 0;                    //жȫּĴ
    INTE2 = 0;                   //жʹܼĴ2
    INTF2 = 0;                   //жϱ־Ĵ2
    init_io();                   //I/Oڳʼ
    init_adc();                  //ADCʼ
}

/***********************************************************
*    void main(void)    
*          
*                                  
*ֵ   
*ú  
*  
*޶Ҫ  2014.01.07 V1.0                                       
***********************************************************/  
void main(void)
{
    init_mcu();
    while(1)
    {
		ADCCL = 0x05;	              //ʹADCתѡͨ0
        convert_adc();
		ADCRH1 =((unsigned int)g_adc_value_h) << 4;
		ADCRH1+= g_adc_value_l >> 4;
        Delay_nus(8000);
		ADCCL = 0x15;	              //ʹADCתѡͨ0
        convert_adc();
		ADCRH1 =((unsigned int)g_adc_value_h) << 4;
		ADCRH1+= g_adc_value_l >> 4;
		Delay_nus(8000);
    }
}
