#include  <hic.h>
#include  <string.h>
#include  "typedef.h"
#include  "macrodef.h"
#include  "rw_flash.h"

/**********************************************
check_empty
  ѯFlashǷΪ
ֵword_addr:Flashʼַ;num:յֽ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 check_empty(u16  word_addr, u8 *buf_Addr, u16 num)
{
	u16  i,buf16;
    for(i = 0; i < (num / 2); i++)
    {
		buf16=Read_SingleWord(word_addr);
        if(buf16 != 0xFFFF)
		{
			return  FAILED;
		}
        ++word_addr;
    }
    return  SUCCESS;
}
/**********************************************
Read_SingleWord
  Flashһ
ֵaddr:Flashַ
ֵ
ֵӦFlashַе
**********************************************/
u16 Read_SingleWord(u16  addr)
{
	__asm{CWDT};
	while(GIE) GIE = 0;
	ROMCL&=~(7<<4);
	ROMCL|=5<<4;
	FRAL = addr;
    FRAH = addr >> 8;
    __Asm  TBR;
    return(((u16)ROMDH << 8) + ROMDL);
}
/**********************************************
Read_Cont
  Flash
ֵword_addr:Flashַ; *buf_Addr:ݱַ; num:ֽ
ֵFlashе
ֵSUCCESSFAILED
**********************************************/
u8 Read_Cont(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;
    for(i = 0; i < (num / 2); i++)
    {
        *(u16 *)buf_Addr = Read_SingleWord(word_addr);
        word_addr++;
        buf_Addr += 2;
    }
    return  SUCCESS;
}
/**********************************************
StartIAP
  IAP̶
ֵ
ֵ
ֵ
**********************************************/
void StartIAP(void)	//IAP̶ʽ
{
	__asm
	{
		MOVI 0x55
		MOVA ROMCH
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		MOVI 0xAA
		MOVA ROMCH
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		NOP
		BSS ROMCL,WR
		JBC ROMCL,WR	//ȴ
		goto $-1
	}
}
/**********************************************
Erase_Page
  һҳFlash
ֵpage_addrҳڵĵַ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 Erase_Page(u16  page_addr)
{
	__asm{CWDT};
	while(GIE) GIE = 0;
	ROMCL=0x50;			//
	FPEE=1;
    FRAH = page_addr >> 8;	//ַֽ
	FRAL = page_addr;		//ַֽ
	FRAHN = ~FRAH;
	FRALN = ~FRAL;
	WREN=1;
	StartIAP();
	ROMCL=0x00;
	return SUCCESS;	
}
/**********************************************
Write_SingleWord
  FlashӦַдһֵ
ֵaddrFlashַ; word_dat:
ֵ
ֵ
**********************************************/
void Write_SingleWord(u16  addr, u16 word_dat)
{
    __asm{CWDT};
	while(GIE) GIE = 0;
	ROMCL=0x50;			//
	FPEE=0;
    FRAH = addr >> 8;	//ַֽ
	FRAL = addr;		//ַֽ
	FRAHN = ~FRAH;
	FRALN = ~FRAL;
    ROMDH = word_dat >> 8; //
	ROMDL = word_dat;	 //дFlashֽ
	WREN=1;
	StartIAP();
}
/**********************************************
Write_SingleWord
  Flashд
ֵword_addrFlashʼַ;buf_Addr:Ҫдݵʼַ num:ݸ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 Write_Cont(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;
    for(i = 0; i < (num / 2); i++)
    {
        Write_SingleWord(word_addr, *((u16 *)buf_Addr));
        word_addr++;
        buf_Addr += 2;
    }
    return  SUCCESS;
}