#include <hic.h>
#include "iic.h"
#include  "typedef.h"

isp_data_t g_isp_data;   //ͨͨ״̬Ĵ
extern u32  g_boot_timer;
extern u32  g_frame_timer;


void iic_init()
{
	PBT0=1;
	PBT1=1;
	ANSL=0xFF;
	I2CC = 0xE4;
	I2CSA = 0x5A;
	I2CEN = 1;
}

void start_tx(u8 len)
{
	g_isp_data.tx_cnt = 0;
	g_isp_data.tx_len = len;
	I2CTB = g_isp_data.tx_buf[0];
	g_isp_data.stx_flag = 1;
}

void iic_receive(void)
{
	volatile u8 buf8;
	while(1)
	{
		buf8 = I2CRB;
		g_boot_timer = Boot_OVERTIME_2;   
		if(g_isp_data.syn)  //ͬɹ
		{
			if((buf8 == SYN) &&(g_isp_data.step == WAIT_REV_INS))
			{
				g_isp_data.tx_buf[0] = ACK;
				start_tx(0);
				g_isp_data.triger=0;
				break;
			}
			else
			{					
				
				if(g_isp_data.step == WAIT_REV_INS)
				{
					g_isp_data.rx_len = 1;
					g_isp_data.rx_cnt = 0;
					g_isp_data.step = IN_REV_INS;  //ڽָ		
				}
				g_isp_data.rx_buf[g_isp_data.rx_cnt] = buf8;
				g_isp_data.rx_cnt++;
				//if(g_isp_data.rx_cnt == 2 && g_isp_data.step == WAIT_REV_PARA1 && g_isp_data.cmd == EX_ERASE)
				//{
					//g_isp_data.rx_len = (g_isp_data.rx_buf[1]+2) * 2;
				//}
				if(g_isp_data.rx_cnt == 1 && g_isp_data.step == WAIT_REV_PARA2 && g_isp_data.cmd == WRITE_M)
				{
					g_isp_data.rx_len = g_isp_data.rx_buf[0] + 2;
				}
				if(g_isp_data.rx_cnt > g_isp_data.rx_len)    //ɣһ
				{
							
					g_isp_data.triger = 1;  //״̬һ
					break;
				}
					
			}
		}
		else if(buf8 == SYN)  //յͬɹ
		{
			g_isp_data.tx_buf[0] = ACK;
			g_isp_data.syn = 1;  //ͬ
			g_isp_data.step = WAIT_REV_INS;
			g_isp_data.triger=0;
			start_tx(0);
			break;
		}
		break;
	}
}
u16 i;
void iic_send(void)
{
	if(g_isp_data.stx_flag == 0)return;
	g_isp_data.tx_cnt++;
	if(g_isp_data.tx_cnt > g_isp_data.tx_len)    //ɣһ
	{
		if(g_isp_data.ctriger == 0)	//jyc
		{
			g_isp_data.triger = 1;      //״̬һ
		}
		else
		{
			g_isp_data.ctriger = 0;
			g_isp_data.fso = 1;
			for(i=0; i<1000; i++);	//jyc ȴ
		}
		g_isp_data.rx_cnt = 0;
		g_isp_data.stx_flag = 0;	//jyc
	}
	else
	{
		I2CTB = g_isp_data.tx_buf[g_isp_data.tx_cnt];
	}
}

volatile u8 data8;

void iic_proc()
{
	if(I2CSRIF)
	{
		I2CSRIF = 0;
		if((I2CRW != 0) && (g_isp_data.fso != 0))	//jyc
		{
			g_isp_data.triger = 1;
			g_isp_data.fso = 0;
		}
	}
	if(I2CRBIF)
	{
		iic_receive();
	}
	if(I2CTBIF)
	{
		iic_send();
	}
	if(I2CNAIF)
	{
		I2CNAIF = 0;
	}
	if(I2CSPIF)
	{
		I2CSPIF = 0;
		I2CRST = 1;
		while(I2CRST);
		iic_init();
	}
}

