/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  uart.c
*  :  AE Team
*  :  v1.0iDesigner(v4.2.3.166) + HRCC(v1.2.0.106)
*  :  2020/09/11
*  :  UARTͨʾ15200bpsCLK:16.588MHz
          PA1TX
          PA2RX
          λͨţ115200λһ"www.essemi.com"Ȼѭյԭء
          ͨ궨ķʽѡòѯͽջѡжϷʽͽա
*  ע:  ES7P0392оƬ̽ο
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define IT_SR       //жϷͽգעʹ˺궨ʹòѯʽͽ
#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ

unsigned char rxbuf;
unsigned char str[] = "www.essemi.com\0";

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH=0; IAAH<=0x03; IAAH++)
    {
        for (IAAL=0; IAAL<0xFF; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
}

void OSCCALStart(void)
{
	__asm{
      TMP1 EQU 1
	  TMP2 EQU 2

	  MOVI		0x90			//ȡINFO1洢16.588MHz(0090H)Ԫ 
      MOVA		FRAL
      MOVI		0x00
      MOVA		FRAH
      MOVI		0x60             //ѡΪINFO1Ϣ
      MOVA		ROMCL
      BSS      ROMCL,0           //INFO1λʹ
      JBC      ROMCL,0
      goto    $-1
        BSS      ROMCL,7           //INFO1ָʹ
        TBR                 
        MOV		ROMDH, 0
        MOVA    TMP1               //ʱĴ1
        MOV		ROMDL, 0
		MOVA    TMP2               //ʱĴ2
		BSS      BKSR,4            //CALPROT, OSCCALĴλڴ洢1
		MOVI     0x55
		MOVA    CALPROT            //ȥ
		MOV     TMP1,0
		MOVA    OSCCALH            //дλĴOSCCALH
		MOV     TMP2,0
		MOVA    OSCCALL            //дλĴOSCCALL
		CLR      CALPROT
		BCC      BKSR,4            //лص洢0
		MOVI		0x00             //˳IAP
		MOVA		ROMCL
	}
}

/**********************************************
void main(void)
  ,QUERY0INT1=0,ѯʽͽաQUERY0INT1=1жϷʽͽ
ֵ
ֵ
ֵ
**********************************************/
void main(void) 
{
    unsigned char *ptr = str;
    //RAMclear();
	OSCCALStart();

    GPIOInit();
    PAT1 = 0;       //TX
    PAT2 = 1;       //RX
    RXM = 0;        //8λݽոʽ
    TXM = 0;        //8λݷ͸ʽ
    BRGH = 1;       //ʸģʽ=Fosc/(16 *(BRR<7:0>+1))
    BRR = 0x08;     //=16.588MHz/(16*(8+1))115200bps

#ifdef IT_SR 
    RXIE = 1;       //ж
    GIE = 1;        //ж
#endif
    RXEN = 1;       //򿪽
    TXEN = 1;       //򿪷
    while (*ptr)        //ͣ"www.essemi.com"
    {
        while (!TRMT);
        TXB = *(ptr++);
        CLRWDT();
    }
    while (1)
    {
#ifndef IT_SR           //ѯʽͽ
        if (RXIF==1)
        {
            rxbuf = RXB;
            while(!TRMT);
            TXB = rxbuf;
        }
#endif
        CLRWDT();
    }
}

/**********************************************
void isr(void) interrupt
  жϷ
ֵ
ֵ
ֵ
**********************************************/
#ifdef IT_SR 
void isr(void) interrupt
{
    if(RXIE==1 && RXIF==1)
    {
        rxbuf = RXB;
        while(!TRMT);
        TXB = rxbuf;
    }
}
#endif