/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  spi_slave.c
*  :  WangYQ
*  :  v1.0iDesigner(v4.2.3.159) + HRCC(v1.2.0.102)
*  :  2018/08/07
*  :  SPIӻģʽʾ
          PA6NSS
          PB4SCK
          PB5MOSI
          PB6MISO
          ӻжϺнյԭأյݱڽջڡ
*  ע:  ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ
#define RXBUF_SIZE 64       //궨ջ

typedef unsigned char uchar;
typedef unsigned int uint;

uchar rxbuf[RXBUF_SIZE];
uint rxcnt = 0;

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH=0; IAAH<=0x03; IAAH++)
    {
        for (IAAL=0; IAAL<0xFF; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
    PAT6 = 1;       //NSSΪ
    PBT4 = 1;       //SCKΪ
    PBT5 = 1;       //MOSIΪ
    //PBT6 = 0;       //MISOΪ
}

/**********************************************
void Init_spi(void)
  SPIʼ
ֵ
ֵ
ֵ
**********************************************/
void Init_spi(void)
{
    SPIRST = 1;     //λSPI
    while(SPIRST);
    SPICON0 = 0xF0;     //CKS = Fosc/16շ
    SPICON1 &= ~(3<<6);
    SPICON1 |= 0<<6;      //0:طͣȣ½ؽգ󣩣
    //SPICON1 |= 1<<6;      //1:½طͣȣؽգ󣩣
    //SPICON1 |= 2<<6;      //2:ؽգȣ½طͣ󣩣
    //SPICON1 |= 3<<6;      //3:½ؽգȣطͣ󣩣
    MS = 1;     //0ģʽ1ӻģʽ
}

/**********************************************
void isr(void) interrupt 
  жϷ
ֵ
ֵ
ֵ
**********************************************/
void isr(void) interrupt
{
    uchar buf8;
    if (RBIE==1 && RBIF==1)     //SPIж
    {
        buf8 = SPIRBR;
        SPITBW = buf8;
        rxbuf[rxcnt++] = buf8;
        if (rxcnt > RXBUF_SIZE-1)
            rxcnt = 0;
        CLRWDT();
    }
    SPI_GIEIF = 0;  //жϱ־
}

/**********************************************
void main(void) 
  
ֵ
ֵ
ֵ
**********************************************/
void main(void) 
{
    uint i;
    RAMclear();
    GPIOInit();
    Init_spi();
    RBIE = 1;       //򿪽ж
    SPI_GIEIE = 1;  //SPIж
    SPI_GIEIF = 0;  //жϱ־
    GIE = 1;        //ж
    REN = 1;        //򿪽
    SPIEN = 1;      //SPIʹ
    while(1)
    {
        CLRWDT();
    }
}
