/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  spi_master.c
*  :  WangYQ
*  :  v1.0iDesigner(v4.2.3.159) + HRCC(v1.2.0.102)
*  :  2018/08/07
*  :  SPIģʽʾ
          PA6NSS
          PB4SCK
          PB5MOSI
          PB6MISO
*  ע:  ES7P003оƬ̽ο
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

#define IT_RECEIVE      //ע͵òѯգжϽ
#define RXBUF_SIZE 64       //ջ
#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ

typedef unsigned char uchar;
typedef unsigned int uint;

uchar txbuf[8] = {0,1,2,3,4,5,6,7};
uchar rxbuf[RXBUF_SIZE];
uint rxcnt;

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH=0; IAAH<=0x03; IAAH++)
    {
        for (IAAL=0; IAAL<0xFF; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
    //PAT6 = 0;       //NSSΪ
    //PBT4 = 0;       //SCKΪ
    //PBT5 = 0;       //MOSIΪ
    PBT6 = 1;       //MISOΪ
}

/**********************************************
void Init_spi(void)
  SPIʼ
ֵ
ֵ
ֵ
**********************************************/
void Init_spi(void)
{
    SPIRST = 1;     //λSPI
    while(SPIRST)
        ;
    SPICON0 = 0xF0;       //CKS = Fosc/16շ
    SPICON1 |= 0<<6;      //0:طͣȣ½ؽգ󣩣
    //SPICON1 |= 1<<6;      //1:½طͣȣؽգ󣩣
    //SPICON1 |= 2<<6;      //2:ؽգȣ½طͣ󣩣
    //SPICON1 |= 3<<6;      //3:½ؽգȣطͣ󣩣
    MS = 0;         ////0ģʽ1ӻģʽ
#ifdef IT_RECEIVE
    RBIE = 1;       //򿪽ж
#else
    RBIE = 0;       //رսж
#endif
    REN = 1;        //򿪽
    SPIEN = 1;      //SPIʹ
}
/**********************************************
void SPIWriteData(uchar *wbuf,uint n)
  SPIݷͳ
ֵʼַͷ͵ݸ
ֵ
ֵ
**********************************************/
void SPIWriteData(uchar *wbuf,uint n)
{
    uchar i;
    PA6 = 0;    //Ƭѡ
    for (i=0; i<255; i++)     //ʱȴӻ׼
        ;
    for (i=0 ;i<n; i++)
    {
        SPITBW = *(wbuf+i);
        while(!IDIF);
        CLRWDT();
    }
    PA6 = 1;
}

/**********************************************
void SPIReadData(uchar *rbuf,uint n)
  SPIݽճ
ֵʼַͷ͵ݸ
ֵյ
ֵ
**********************************************/
void SPIReadData(uchar *rbuf,uint n)
{
    uint i;
    PA6 = 0;        //Ƭѡ
    for (i = 0;i<1000;i++)    //ʱȴӻ׼
        ;
    RXCLR = 1;      //սݼĴ
    rxcnt = 0;      //ռλ
    REN = 1;        //ʱ򿪽
    for (i=0; i<n; i++)
    {
        while (!IDIF)   //ȴ
            ;   
        SPITBW = 0xFF;  //д
        if (RBIE == 0)
        {
            while (!RBIF);   //ȴ
            *(rbuf+i) = SPIRBR;     //
        }
        CLRWDT();
    }
    PA6 = 1;
    REN = 0;    //رս  
}

/**********************************************
void isr(void) interrupt 
  жϷ
ֵ
ֵ
ֵ
**********************************************/
void isr(void) interrupt
{
    if (RBIE==1 && RBIF==1)     //SPIж
    {
        rxbuf[rxcnt++] = SPIRBR;
        if (rxcnt > RXBUF_SIZE-1)
            rxcnt = 0;
    }
    SPI_GIEIF = 0;//жϱ־
}

/**********************************************
void main(void) 
  
ֵ
ֵ
ֵ
**********************************************/
void main(void) 
{
    uint i;
    //RAMclear();
    GPIOInit();
    Init_spi();
    SPI_GIEIE = 1;  //SPIж
    GIE = 1;    //ж
    while(1)
    {
        SPIWriteData(txbuf,8);
        for(i = 0;i<10000;i++)
            ;
        SPIReadData(rxbuf,8);
        for(i = 0;i<10000;i++)
            ;
        CLRWDT();
    }
}
