/*******************************************************
*Copytight(C),2017,Shanghai Eastsoft Microelectronics Co.,Ltd.
*ļiap_dataflash.c
*  ߣwangyq
*  v1.1iDesigner(v4.2.3.159) + HRCC(v1.2.0.102)
*  ڣ2018/8/8
*  IAPַ0x1F00~0x1FFF
        IAPҳ(256ַԪ)Ϊλһִַвǲַڵһҳ
        IAPдһַԪΪλ(һַԪӦһWord)ÿҳʱ2msַʱ20us
		IAPֹܷ
        ע⣺IAPǰرWDT(ѡWDTENΪDisable)ʹWDTúWDTʱ䣬幷
*  עES7P003̽ο
ѧϰʾʹãûֱôķջеκηΡ
*******************************************************/
#include <hic.h>

#define CLRWDT()   {__Asm CWDT;}        //궨幷ָ

#define STARTADDR    0x1F00     //궨IAPʼַ
#define ENDADDR      0x1FFF     //궨IAPַ
#define WRDATA       0x55AA     //궨д

unsigned char dataerr = 0;      //0дȣ1д

unsigned char CallFlashEn,FlashEwEn;//

/******************************************************
void RAMclear(void)
  RAM㣬RAMַ0x0000~0x03FF
ֵ
ֵ
ֵ
*******************************************************/
void RAMclear(void)
{
    for (IAAH=0; IAAH<=0x03; IAAH++)
    {
        for (IAAL=0; IAAL<0xFF; IAAL++)
            IAD = 0x00;
        IAD = 0x00;
    }
}

/******************************************************
void GPIOInit(void)
  ȳʼδõIOΪ͵ƽ
ֵ
ֵ
ֵ
*******************************************************/
void GPIOInit(void)
{
    ANSL = 0xFF;        //ѡӦ˿ΪIO
    PAT = 0x00;         //IOΪ͵ƽ
    PBT = 0x00;
    PCT = 0x00;
    PA = 0x00;
    PB = 0x00;
    PC = 0x00;
}

/******************************************************
void StartIAP(void)
  ʼIAPע⣺IAP̶ʽʹʱɸı
ֵ
ֵ
ֵ
*******************************************************/
void StartIAP(void)
{
    __asm{
          MOVI 0x55
          MOVA ROMCH
          MOVI 0xFF     //8NOP俪ʼ
          SECSEL &FlashEwEn& % 0x80//ѡڵsection
          XOR &FlashEwEn& % 0x80,0//0xFF xor 0xAA = 0x55
          SECSEL &CallFlashEn& % 0x80//ѡڵsection
          XOR &CallFlashEn& % 0x80,0//CallFlashEnڵúǰΪ0x550x55 xor 0x55 = 0x00
          JBS PSW,Z//Ϊ0x00ִȷһNOP
          GOTO $+3
          NOP//8NOP
          MOVI 0xAA
          MOVA ROMCH
          MOVI 0xFF     //8NOP俪ʼ
          SECSEL &FlashEwEn& % 0x80//ѡڵsection
          XOR &FlashEwEn& % 0x80,0//0xFF xor 0xAA = 0x55
          SECSEL &CallFlashEn& % 0x80//ѡڵsection
          XOR &CallFlashEn& % 0x80,0//CallFlashEnڵúǰΪ0x550x55 xor 0x55 = 0x00
          JBS PSW,Z//Ϊ0x00ִȷһNOP
          GOTO $+3
          NOP//8NOP
          BSS ROMCL,WR     //̲
          JBC ROMCL,WR
          goto $-1         //ȴ
        }
}

/*******************************************************
void DataFlashErsPage(void)
  DataFlashҳ(256 word)ַΧ0x1F00~0x1FFF
ֵ
ֵ
ֵ
*******************************************************/
void DataFlashErsPage(void)
{
	unsigned char gie_bk = GIE;		//GIE
    CLRWDT();
	while(GIE == 1)GIE = 0;            //IAPǰرȫж   
    ROMCL = 0x40;       //ѡIAP 
    FPEE = 1;           //洢ģʽ
    FRAH = 0x1F;
    FRAL = 0x00;
    FRAHN = ~FRAH;      //IAP/ַ̱ȡ߼
    FRALN = ~FRAL;     
	FlashEwEn = 0xAA;//
    WREN = 1;           //ʹܲ/̹
    StartIAP();         //ʼIAP
	CallFlashEn = 0;//
	FlashEwEn = 0;
    ROMCL = 0x00;       //˳IAP
	GIE = gie_bk;       //ָȫж
}

/*******************************************************
unsigned int DataFlashRdData(unsigned int addr)
  Flashַָ
ֵDataFlashַaddrַΧ0x1F00~0x1FFF
ֵ
ֵDataFlashַָ
*******************************************************/
unsigned int DataFlashRdData(unsigned int addr)
{
	unsigned int data;
	unsigned char gie_bk = GIE;	  //GIE
    CLRWDT();
	while(GIE == 1)GIE = 0;
    ROMCL = 0x40;       //ѡIAP
    FRAH = addr>>8;
    FRAL = addr;
    __Asm TBR;          //ָ
    data = (unsigned int)ROMDH<<8 | ROMDL;
    GIE = gie_bk;       //ָȫж
	return data;
}

/*******************************************************
void DataFlashWrData(unsigned int addr, unsigned int word)
  дDataFlashַָݣַΧ0x1F00~0x1FFF
ֵDataFlashַaddrдword
ֵ
ֵ0:дʧܣ1:дɹ
*******************************************************/
unsigned char DataFlashWrData(unsigned int addr, unsigned int word)
{
    unsigned char rmdh,rmdl;      //ʱROMDHROMDLֵ
	unsigned char gie_bk = GIE;	  //GIE
    CLRWDT();
	while(GIE == 1)GIE = 0;            //IAPǰرȫж
    ROMCL = 0x40;       //ѡIAP 
    FPEE = 0;           //洢ģʽ
    ROMDH = word>>8;    //дWordĸֽ
    ROMDL = word;
    FRAH = addr>>8;     //IAP̵ַ
    FRAL = addr;
    FRAHN = ~FRAH;      //IAP/ַ̱ȡ߼
    FRALN = ~FRAL;       
	FlashEwEn = 0xAA;//
    WREN = 1;           //ʹܱ   
    StartIAP();         //ʼIAP
	CallFlashEn = 0;//
	FlashEwEn = 0;
    rmdh = ROMDH++;
    rmdl = ROMDL++;
    __Asm TBR;          //ָ
    if (ROMDH!=rmdh || ROMDL!=rmdl)
	{
        ROMCL = 0x00;       //˳IAP
		return 0;
	}
	FRAH = 0xFF;//ָõĵַռ
	FRAH = 0xFF;//ָõĵַռ
	ROMDH = 0xFF;//ݳʼΪ0xFF
	ROMDL = 0xFF;//ݳʼΪ0xFF
    ROMCL = 0x00;       //˳IAP
	GIE = gie_bk;       //ָȫж
    return 1;
}

/*******************************************************
void main(void)
  IAPַ0x1F00~0x1FFF
ֵ
ֵ
ֵ
*******************************************************/
void main(void)
{
    unsigned char i;
    unsigned int j;
    unsigned int dtflashaddr;       //ַDataFlashд

    RAMclear();
    GPIOInit();

/************IAPFlash(256Word)****/
	CallFlashEn = 0x55;			//CallFlashEnֵ0x55ִв̲
    DataFlashErsPage();
    CLRWDT();

/******************IAPд벢У******************/
    for (dtflashaddr=STARTADDR; dtflashaddr<=ENDADDR; dtflashaddr++)
    {
		CallFlashEn = 0x55;		//CallFlashEnֵ0x55ִв̲
        i = DataFlashWrData(dtflashaddr,WRDATA);
        if (i != 1)
            dataerr = 1;        //У
    }
    ROMCL = 0x00;       //˳IAP
    CLRWDT();

/******************IAPУ(ʾ)******************/
    for (dtflashaddr=STARTADDR; dtflashaddr<=ENDADDR; dtflashaddr++)
    {
        j = DataFlashRdData(dtflashaddr);
        if (j != WRDATA)
            dataerr = 1;        //У
    }
    ROMCL = 0x00;       //˳IAP
    CLRWDT();

    while (1)
    {
        CLRWDT();
    }
}