/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:    pwm.c
*  :    XieYF
*  :    V1.50
*  :    2015/5/28
*  :    ׼PWM
            1.ʹоƬT11չģPWMPA5˿ʵƵΪ10KHz~28.5KHzΪ100us~35usռ
              Ϊ50%ķ
            2.оƬʹ16MHzϵͳʱӣӦT11ʱʱԴΪ1/16MHzT11ԤƵ1:8T11
              ĴT11Pʼֵļ㹫ʽӦΪ
              PWM100us =T11P+1(1/16MHz)8ԤƵȣõT11P ֵperiod= 199(0xC7)
              PMM50us = T11RL (1/16MHz)8ԤƵȣõT11RLֵduty =100(0x64)
              PWMռձ 50% = T11RL/ T11P+1
*  ע:    HR7P169B
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#define period 199
#define duty 100
unsigned int n_period;
unsigned char n_duty;


/*********************************************************
: void clear_ram(void)
  : RAMȫ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/  
void clear_ram(void) 
{
    __asm 
    { 
         CLR   IAAL;
         CLR   IAAH;
         CLR   IAD;
         INC   IAAL,1;
         JBS   PSW,C
         GOTO  $-3;
         INC   IAAH,1;
         JBS   IAAH,2
         GOTO  $-6;
    } 
}

/*********************************************************
: void isr(void) interrupt
  : жϷ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void isr(void) interrupt
{
    if(T11PIE &&T11PIF) 
    {
        T11PIF = 0;
        if(n_period >=70)
        {
            n_period-= 2;   
            T11PH = n_period>>8;
            T11PL = n_period;           //PWM
            T11RL = n_period/2;         //PWM
            while(PWM1XUD);
            PWM1XUD = 1;                //ʹܾȺڻʱ
        }
        else
        {
            n_period = period;
        }
    }
}

/*********************************************************
: void main()
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main()
{
	clear_ram();                        //ram

    ANSL = 0xff;                        //PAΪI/O
    PA5 = 0;                            //PA5˿͵ƽ
    PAT5 = 0;                           //PA5˿Ϊ  
    n_period = period;
    T11C =  0x81;                       //ʹPWMģʽ
    T11CH = 0x17;                       //ʹԤƵ2ԤƵ2Ƶ1:8
    PWM1C = 0x01;		                
    T11OC = 0x82;		                //ʹʵʱģʽ
    T11RL = duty;		                //PWMȼĴ
    T11PH = n_period>>8;   
    T11PL = period;		                //PWMڼĴ   
    T11PIE = 1;			                //ʹж
    GIE = 1;			                //ʹȫж
    T11EN = 1;			                //ʹT11ʱ
    while(1);
}
