/*********************************************************
*Copyright (C), 2015, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:    flash.c
*  :    XieYF
*  :    V1.50
*  :    2017/5/31
*  :    ڲFlashд
            1.HR7P169Bڲ1KֽFLASH洢 2ҳÿҳ512ֽڣֲ֧дַΧΪ1E00H~1FFFH
            2.ָͨFRAָĵַԪеһֶROMDС
            3.FLASHдΪλдǰȲдԪڵҳдFLASHʱݱݣҳֱ̡
            4.оƬҳʱΪ2msڼоƬͣ״̬
            5.FLASH洢/дǰоƬʹFRENλѡDPAGES<1:0> FLASH洢ҳѡλѡpage1~2
            6.ûִҳʱرWDTڲRCʱӣִвʱŹλоƬ
            7.Flash洢ĿɿԲAN062_Ӧñʼ_MCUƬڷʧԴ洢
*  ע:    HR7P169B
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>

unsigned int RamBuff[16];         //Ram16

union{
    unsigned int Word;
    unsigned char Byte[2];
}FlashAddr;                       //Flashַ
union{
    unsigned int Word;
    unsigned char Byte[2];
}FlashData;                       //Flashݱ

void clear_ram(void);			  //ramʼ
/*********************************************************
: void clear_ram(void)
  : RAMȫ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/  
void clear_ram(void) 
{
    __asm 
    { 
         CLR   IAAL;
         CLR   IAAH;
         CLR   IAD;
         INC   IAAL,1;
         JBS   PSW,C
         GOTO  $-3;
         INC   IAAH,1;
         JBS   IAAH,2
         GOTO  $-6;
    } 
}

unsigned char CallFlashEn, FlashEwEn;//

void start_iap(void)
{
    __asm{
          MOVI 0x55
          MOVA ROMCH
          MOVI 0xFF     //8NOP俪ʼ
          SECSEL &FlashEwEn& % 0x80//ѡڵsection
          XOR &FlashEwEn& % 0x80,0//0xFF xor 0xAA = 0x55
          SECSEL &CallFlashEn& % 0x80//ѡڵsection
          XOR &CallFlashEn& % 0x80,0//CallFlashEnڵúǰΪ0x550x55 xor 0x55 = 0x00
          JBS PSW,Z//Ϊ0x00ִȷһNOP
          GOTO $+3
          NOP//8NOP
          MOVI 0xAA
          MOVA ROMCH
          MOVI 0xFF     //8NOP俪ʼ
          SECSEL &FlashEwEn& % 0x80//ѡڵsection
          XOR &FlashEwEn& % 0x80,0//0xFF xor 0xAA = 0x55
          SECSEL &CallFlashEn& % 0x80//ѡڵsection
          XOR &CallFlashEn& % 0x80,0//CallFlashEnڵúǰΪ0x550x55 xor 0x55 = 0x00
          JBS PSW,Z//Ϊ0x00ִȷһNOP
          GOTO $+3
          NOP//8NOP
          BSS ROMCL,WR     //̲
		  NOP
		  NOP
          JBC ROMCL,WR
          goto $-1         //ȴ
        }
}

static void data_flash_ers_page(unsigned int addr)
{
	unsigned char gie_bk = GIE;
	__asm{CWDT};		//幷
	while(GIE == 1)GIE = 0;            //IAPǰرȫж 
    FPEE = 1;           //洢ģʽ
    FRAH = addr>>8;
    FRAL = addr; 
	FlashEwEn = 0xAA;//
    WREN = 1;           //ʹܲ/̹  
    start_iap();         //ʼIAP
	CallFlashEn = 0;//
	FlashEwEn = 0;
    ROMCL = 0x00;       //˳IAP
	GIE = gie_bk;		//ָȫж
}

static unsigned int data_flash_rd_data(unsigned int addr)
{
	unsigned char rmdh,rmdl;      //ʱROMDHROMDLֵ
	unsigned char gie_bk = GIE;
	__asm{CWDT};		//幷
	while(GIE == 1)GIE = 0;            //IAPǰرȫж 
    FRAH = addr>>8;
    FRAL = addr;
    __Asm TBR;          //ָ
	rmdh = ROMDH;
	rmdl = ROMDL;
	FRAH = 0xFF;//ָõĵַռ
	FRAH = 0xFF;//ָõĵַռ
	ROMDH = 0xFF;//ݳʼΪ0xFF
	ROMDL = 0xFF;//ݳʼΪ0xFF
    ROMCL = 0x00;       //˳IAP
	GIE = gie_bk;		//ָȫж
    return (unsigned int)rmdh<<8 | rmdl;
}

static unsigned char data_flash_wr_data(unsigned int addr, unsigned int word)
{
    unsigned char rmdh,rmdl;      //ʱROMDHROMDLֵ
	unsigned char gie_bk = GIE;
	__asm{CWDT};		//幷
	while(GIE == 1)GIE = 0;            //IAPǰرȫж   
    FPEE = 0;           //洢ģʽ
    ROMDH = word>>8;    //дWordĸֽ
    ROMDL = word;
    FRAH = addr>>8;     //IAP̵ַ
    FRAL = addr;     
	FlashEwEn = 0xAA;//
    WREN = 1;           //ʹܱ
    start_iap();         //ʼIAP
	CallFlashEn = 0;//
	FlashEwEn = 0;
    rmdh = ROMDH++;
    rmdl = ROMDL++;
    __Asm TBR;          //ָ
    if (ROMDH!=rmdh || ROMDL!=rmdl)
	{
        ROMCL = 0x00;       //˳IAP
		return 0;
	}
	FRAH = 0xFF;//ָõĵַռ
	FRAH = 0xFF;//ָõĵַռ
	ROMDH = 0xFF;//ݳʼΪ0xFF
	ROMDL = 0xFF;//ݳʼΪ0xFF
    ROMCL = 0x00;       //˳IAP
	GIE = gie_bk;		//ָȫж
    return 1;
}

void main(void)
{
    unsigned char i;

	clear_ram();
    FlashAddr.Word = 0x1E00;            //ʼַ   
    for(i=0;i<16;i++)
    {
        RamBuff[i] = data_flash_rd_data(FlashAddr.Word);    //ݵǰRam
        FlashAddr.Word++;      
    }    

    FlashAddr.Word = 0x1E00;            //ʼַ 
	CallFlashEn = 0x55;					//úǰֵ0x55
    data_flash_ers_page(FlashAddr.Word);//ҳFlash

    for (i=0;i<16;i++)
    {
        RamBuff[i] = i;                 //޸Ram8ֽ
    }       
    
    FlashAddr.Word = 0x1E00;            //ʼַ  
    for(i=0;i<16;i++)
    {
        FlashData.Word = RamBuff[i];
		CallFlashEn = 0x55;
        data_flash_wr_data(FlashAddr.Word, FlashData.Word);                   //дFlash  
        FlashAddr.Word++;        
    }    

    for (i=0;i<16;i++)
    {
        RamBuff[i] = 0;                 //޸Ram
    }     
    
    FlashAddr.Word = 0x1E00;            //ʼַ 
    for(i=0;i<16;i++)
    {
        RamBuff[i] = data_flash_rd_data(FlashAddr.Word);    //Ƿд
        FlashAddr.Word++;      
    }    
    
    while(1)
	{
		__asm{CWDT};		//幷
	}
}

  