/*********************************************************
*Copyright (C), 2017, Shanghai Eastsoft Microelectronics Co., Ltd.
*ļ:	adc.c
*  :	YouL
*  :	V1.21
*  :	2017/08/30
*  :	ADC
            1.ʹHR7P169BоƬADCģ飬òѯʽʵֶģѹת
            2.HR7P169B֧14ͨתֱΪ12bit
            3.ADCתת̡̲õͨ(ͨ2)ADCʾ
*  ע:    HR7P169B
ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include <hic.h>
#include <string.h>
 
unsigned int ADC_Data;            //ADCת
unsigned int ADC_AIN2[100];       //AIN2ת
unsigned char j;
 
/*********************************************************
: void clear_ram(void)
  : RAMȫ
ֵ: 
ֵ: 
ֵ:  
**********************************************************/  
void clear_ram(void) 
{
    __asm 
    { 
         CLR   IAAL;
         CLR   IAAH;
         CLR   IAD;
         INC   IAAL,1;
         JBS   PSW,C
         GOTO  $-3;
         INC   IAAH,1;
         JBS   IAAH,2
         GOTO  $-6;
    } 
}
 
/*********************************************************
: unsigned int ADCConvert(void)
  : ADCת
ֵ: 
ֵ: 
ֵ: dataADC 
**********************************************************/
unsigned int ADCConvert(void)
{
	unsigned int data;
	ADTRG = 1;						//ADת
	while(ADTRG);					//ȴADתɣ12λֵ
    ADIF = 0;

	data = ((unsigned int)ADCRH) << 8;	//ȡADCRH<3:0>
	data += ADCRL;						//ȡADCRL<7:0>
	return data;
}
 
 /*********************************************************
:	unsigned int ADCRead()
  :	ADCתת18ΣȥСֵֵ16ƽֵ
ֵ: 
ֵ: 
ֵ: dataADC
**********************************************************/
unsigned int ADCRead()
{
	unsigned int max, min, sum, ad_temp; 
	unsigned char  i;
	unsigned int data;

	max = 0x00;
	min = 0xffff;
	sum = 0x00;
	for (i=0; i<18; i++)
	{
		ad_temp = ADCConvert();

		if (ad_temp > max)
		{
			 max = ad_temp;				//滻ֵ 
		}
		if (ad_temp < min)
		{
			min = ad_temp;				//滻ֵ 
		}
		sum += ad_temp;
	}
	sum -= min;
	sum -= max; 
	data = sum >> 4;					//16ȡƽֵ
	return data;
}

/*********************************************************
: void main()
  : 
ֵ: 
ֵ: 
ֵ:  
**********************************************************/
void main(void)
{
    clear_ram();        //ʼRAM
 
    ANSL = 0xFB;        //AIN2Ϊģ˿
    ANSH = 0xFF;        //ֶ˿
 
    PAT = 0xFF;
    PBT = 0xFF;
    PCT = 0x00;
 
    PC = 0;             //PC˿͵ƽ 
    PCT1 = 0;           //TX
    PCT0 = 1;           //RX
    BRGH = 1;           //ʸģʽFosc/(16*(BRR+1))
    BRR = 103;			//9600bps=Fosc/(16(BRR<7:0> + 1))@16MHz 
    TXM = 0;            //8λݸʽ
    TXEN = 1;           //UARTʹ
 
    ADHSEN =1;
    ADVCMHS = 1;
    VREFEN = 1;
    ADCCL = 0x25;       //A/Dת,ӲƲAIN2
    ADCCH = 0xCD;       //ADCʱΪ8ADCʱӣֵλ룬A/DתʱƵΪFosc/16οѹΪVREF
    ADCConvert();       //1תֵܲ׼趪
    j = 0;
    while(1)
    {
		ADC_AIN2[j] = ADCRead();		//˲ADCֵ
        //ADC_AIN2[j] = ADCConvert();	//δ˲ADCֵ

        while(!TRMT);               //ȴλĴTXR       
		TXB  =  ADC_AIN2[j]>>8;     //ADCݸ4λ
        while(!TRMT);               //ȴλĴTXR  
		TXB  =  ADC_AIN2[j];		//ADCݵ8λ
 
        j++;
        if(j>100)
        {
            j = 0;
        }
    }
}
