/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  ES_STLcrcrun16.c
*  :  Eastsoft AE Team
*  :  V1.00
*  :  2018/06/21
*  :  Contains the functions performing run time invariable
  *                      memory checks based on 16-bit CRC
*  ע: ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
/* Includes ------------------------------------------------------------------*/
#include "lib_config.h"
#include "ES_STL_param.h"
#include "ES_STLclassBvar.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/**
  * @brief  Inializes the pointers to the Flash memory required during
  *   run-time
  * @param : None
  * @retval : None
  */
void STL_FlashCrc16Init(void)
{

    p_RunCrc16Chk = (uint8_t *)(FLASH_START);
    p_RunCrc16ChkInv = (uint8_t *)(uint32_t)(~((uint32_t)(FLASH_START)));

    CurrentCrc16 = 0u;
    CurrentCrc16Inv = 0xFFFFu;
}

/* ---------------------------------------------------------------------------*/
/**
  * @brief  Computes the crc in multiple steps and compare it with the
  *   ref value when the whole memory has been tested
  * @param : None
  * @retval : ClassBTestStatus = (TEST_RUNNING, CLASS_B_DATA_FAIL,
  *   TEST_FAILURE, TEST_OK)
  */
ClassBTestStatus STL_crc16Run(void)
{
    ClassBTestStatus Result = CTRL_FLW_ERROR; /* In case of abnormal func exit*/

    CtrlFlowCnt += CRC16_RUN_TEST_CALLEE;

    if ((((uint32_t)(p_RunCrc16Chk)) ^ ((uint32_t)(p_RunCrc16ChkInv))) == 0xFFFFFFFFuL)
    {
        /* Check Class B var integrity */
        if ((CurrentCrc16 ^ CurrentCrc16Inv) == 0xFFFFu)
        {
            if (p_RunCrc16Chk < (uint8_t *)(FLASH_END))
            {
                if ((p_RunCrc16Chk + FLASH_BLOCK) > (uint8_t *)FLASH_END)
                {
                    CurrentCrc16 = STL_crc16(CurrentCrc16, p_RunCrc16Chk, FLASH_END - p_RunCrc16Chk + 1);
                }
                else
                {
                    CurrentCrc16 = STL_crc16(CurrentCrc16, p_RunCrc16Chk, FLASH_BLOCK);
                }

                CurrentCrc16Inv = ~CurrentCrc16;  /* Store crc for next run */
                p_RunCrc16Chk += FLASH_BLOCK;     /* Increment pointer to next block */
                p_RunCrc16ChkInv = ((uint8_t *)(uint32_t)(~((uint32_t)p_RunCrc16Chk)));
                Result = TEST_RUNNING;
            }
            else
            {

                if (CurrentCrc16 != __checksum) /* test modified for Keil */

                {
                    Result = TEST_FAILURE;
                }
                else
                {
                    Result = TEST_OK;
                }

                STL_FlashCrc16Init(); /* Prepare next test (or redo it if this one failed) */
            }
        }
        else  /* Class B error CurrentCrc16 */
        {
            Result = CLASS_B_DATA_FAIL;
        }
    }
    else  /* Class B error p_RunCrc16Chk */
    {
        Result = CLASS_B_DATA_FAIL;
    }

    CtrlFlowCntInv -= CRC16_RUN_TEST_CALLEE;

    return (Result);
}

/******************* (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
