/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  ES_STL_clockstart.c
*  :  Eastsoft AE Team
*  :  V1.00
*  :  2018/06/21
*  :  CLASSB
*  ע:
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
/* Includes ------------------------------------------------------------------*/
#include "lib_config.h"
#include "ES_STL_param.h"
#include "ES_STLclassBvar.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

void delay(uint32_t  n)
{
    uint32_t i;

    for (i = 0; i < n; i++)
    {
        __NOP();
    }

}
/* Private functions ---------------------------------------------------------*/
/**
  * @brief  Start up the internal and external oscillators and verifies
  *   that clock source is within the expected range
  * @param :  None
  * @retval : ClockStatus_TEST_FAIL or ClockStatus_TEST_SUCCESSFUL
  */
ClockStatus STL_ClockStartUpTest(void)
{
    IWDT_InitStruType x;
    uint32_t ClockFrequency0;
    uint32_t ClockFrequency1;
    uint32_t ClockFrequency_temp;
    ClockStatus Result = ClockStatus_TEST_FAIL;


    CtrlFlowCnt += CLOCK_TEST_CALLEE;

    ClockFrequency0 = 0xFFFFFFul - SYSTICK_5MS_COUNT;//(0xFFFFFFul - SYSTICK_5MS_COUNT) 5ms sysclkϵͳʱµֵ
    SysTick_Disable();      //ʹʱſ

    IWDT_RegUnLock();
    x.WDT_Tms = 5;           //ι5*2ms
    x.WDT_IE = ENABLE;
    x.WDT_Rst = DISABLE;
    x.WDT_Clock = WDT_CLOCK_WDT;
    IWDT_Init(&x);
    NVIC_Init(NVIC_IWDT_IRQn, NVIC_Priority_0, DISABLE);
    IWDT_Enable();            //WDTڽEnable
    SysTick_Enable();

    while (IWDT_GetFlagStatus() == RESET) ;  //WDTιڵһʱжϱʶ

    ClockFrequency1 = SysTick->VAL;
    SysTick_Disable();
    IWDT_Disable();            //WDTڽDisable
    IWDT_RegLock();

    if (SysTick->CTRL == 0x10000)   //Systickʱӹ
    {
        Result = ClockStatus_TEST_FAIL;
    }
    else if (ClockFrequency0 > ClockFrequency1)
    {
        ClockFrequency_temp = ClockFrequency0 - ClockFrequency1;

        if (ClockFrequency_temp < (SYSTICK_5MS_COUNT / 2))
        {
            Result = ClockStatus_TEST_SUCCESSFUL;
        }
    }
    else
    {
        ClockFrequency_temp = ClockFrequency1 - ClockFrequency0;

        if (ClockFrequency_temp < (SYSTICK_5MS_COUNT))
        {
            Result = ClockStatus_TEST_SUCCESSFUL;
        }
    }

    CtrlFlowCntInv -= CLOCK_TEST_CALLEE;

    return (Result);
}
/******************* (C) COPYRIGHT ESMicroelectronics *****END OF FILE****/
