/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  ES_STLclockrun.c
*  :  Eastsoft AE Team
*  :  V1.00
*  :  2018/06/21
*  :  This file contains the function returning a 16-bit CRC
*                      of part (or whole of) the Flash memory.
*  ע:
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
/* Includes ------------------------------------------------------------------*/
#include "lib_config.h"
#include "ES_STL_param.h"
#include "ES_STLclassBvar.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/
ClockStatus STL_ClockFreqTest(void);
ClockStatus STL_CheckPeriod(uint32_t Period);
void STL_RtcConfig(void);
/**
  * @brief  Initializes the SysTick for clock frequency measurement and
  *   main time base. The RTC is reset and synchronized with the
  *   SysTick to have a direct comparison with reference period
  *   (RTC counter is read during each SysTick interrupt).
  * @param :  None
  *   None
  * @retval : None
  */
void STL_RtcConfig(void)
{
    RTC_Init(RTC_LRC, RTC_HOUR24);

    RTC_WriteSecond(30);
    RTC_ClearAllITFlag();
    RTC_InterruptEnable(RTC_Interrupt_Source_Second);
    NVIC_EnableIRQ(RTC_IRQn);
}

/* ---------------------------------------------------------------------------*/
/**
  * @brief  This function verifies that external clock source frequency
  *   did not change vs initial measurement (done with internal
  *   oscillators only.
  * @param :  None
  *   None
  * @retval : ClockStatus = (LSI_START_FAIL, HSE_START_FAIL,
  *   HSI_HSE_SWITCH_FAIL, TEST_ONGOING, EXT_SOURCE_FAIL,
  *   CLASS_B_VAR_FAIL, CTRL_FLOW_ERROR, FREQ_OK)
  */
ClockStatus STL_ClockFreqTest(void)
{
    ClockStatus Result = ClockStatus_TEST_FAIL;

    ISRCtrlFlowCnt += CLOCKPERIOD_ISR_CALLEE;



    /* Verify first measure integrity and use it as reference */
    if ((LastRTCPeriod ^ LastRTCPeriodInv) != 0xFFFFFFFFuL)
    {
        Result = ClockStatus_TEST_FAIL;
    }
    else if ((LastRTCPeriod < SYSTICK_1S_TB_MAX) && (LastRTCPeriod > SYSTICK_1S_TB_MIN))
    {
        Result = ClockStatus_TEST_SUCCESSFUL;
    }
    else
    {
        Result = ClockStatus_TEST_FAIL;
    }

    ISRCtrlFlowCntInv -= CLOCKPERIOD_ISR_CALLEE;

    return (Result);

}



/******************* (C) COPYRIGHT ESMicroelectronics *****END OF FILE****/

