/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  ES_STL_param.h
*  :  Eastsoft AE Team
*  :  V1.00
*  :  2018/11/12
*  :  CLASSB
*  ע:  ES8P508x
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __SELFTEST_PARAM_H
#define __SELFTEST_PARAM_H

/* Includes ------------------------------------------------------------------*/
#include "ES8P508x.h"
#include "type.h"

/* Exported types ------------------------------------------------------------*/
typedef enum
{
    ClockStatus_TEST_FAIL,
    ClockStatus_TEST_SUCCESSFUL,
} ClockStatus;

typedef enum
{
    TEST_RUNNING,
    CLASS_B_DATA_FAIL,
    CTRL_FLW_ERROR,
    TEST_FAILURE,
    TEST_OK
} ClassBTestStatus;

typedef enum
{
    CPU_TEST_FAIL,
    CPU_TEST_SUCCESSFUL,
} CPUStatus;


/* Exported constants --------------------------------------------------------*/
#define STL_VERBOSE_PRINTF

/* These are the direct and inverted data (pattern) used during the RAM
test, performed using March C- Algorithm */
#define UINT32_ALL_00       ((uint32_t)0x00000000uL)
#define UINT32_ALL_FF       ((uint32_t)0xFFFFFFFFuL)

#define RT_RAM_BLOCKSIZE      ((uint32_t)6u)  /* Number of RAM words tested at once */


/* The counter of systick in 5ms */
#define SYSTICK_5MS_COUNT  (48000000ul/200)    /* 0.005*SystemCoreClock */
/* The number of ticks in a given period of time(base on 10ms systick irq) */
#define SYSTICK_100MS_TB  ((uint32_t)10uL) /* 10*10ms */
#define SYSTICK_1S_TB  ((uint32_t)100uL) /* 100*10ms */
#define SYSTICK_1S_TB_MAX  ((uint32_t)SYSTICK_1S_TB*3u)/2u /* SYSTICK_1S_TB + 25% */
#define SYSTICK_1S_TB_MIN  ((uint32_t)SYSTICK_1S_TB*1u)/2u /* SYSTICK_1S_TB - 25% */
/* Initial value of the CRC */
#define CRC_INIT ((uint32_t)0x00000000uL)

/* define the maximum U32 */
#define U32_MAX    ((uint32_t)4294967295uL)

/* ------------------ CONTROL FLOW TAGS and CHECKPOINTS --------------------- */
#define CPU_TEST_CALLER         ((uint32_t)2)
#define CPU_TEST_CALLEE         ((uint32_t)3) /* Do not modify: hard coded in assembly file */
#define WDG_TEST_CALLER         ((uint32_t)5)
#define CRC16_TEST_CALLEE       ((uint32_t)19)
#define CLOCK_TEST_CALLER       ((uint32_t)23)
#define CLOCK_TEST_CALLEE       ((uint32_t)29)
#define STACK_OVERFLOW_TEST     ((uint32_t)53)
#define STACK_OVERFLOW_CALLEE   ((uint32_t)59)
#define CRC16_RUN_TEST_CALLEE   ((uint32_t)67)
#define FLASH_TEST_CALLER       ((uint32_t)73)

#define CLOCKPERIOD_ISR_CALLEE  ((uint32_t)5)
#define RAM_MARCHC_ISR_CALLER   ((uint32_t)7)
#define RAM_MARCHC_ISR_CALLEE   ((uint32_t)11)


#ifdef __IAR_SYSTEMS_ICC__  /* IAR Compiler */
    /* Magic pattern for Stack overflow in this array */
    __no_init extern __IO uint32_t StackOverFlowPtrn[4] @ "STACK_BOTTOM";

    /* This is the IAR compiler entry point, usually executed right after reset */
    extern void __iar_program_start(void);
    extern uint16_t __checksum;

    /* The 4 variables here above are set by IAR linker */

    /* Constants necessary for Flash CRC calculation */
    #define FLASH_START       (((uint8_t *) 0x00000000))
    #define FLASH_END         ((uint8_t *)(0x1FFFE) - 1)
    #define FLASH_SIZE        ((uint32_t)FLASH_END - (uint32_t)FLASH_START + 1)

    #define STEPS_NUMBER        ((uint32_t)FLASH_SIZE/64)
    #define FLASH_SIZEinWORDS   (uint32_t) (FLASH_SIZE/4)
    #define FLASH_BLOCK         (uint32_t)((FLASH_SIZE) / STEPS_NUMBER)
    #define FLASH_BLOCK_WORDS   (uint32_t)((FLASH_SIZEinWORDS) / STEPS_NUMBER)

    /* Constants necessary for RAM test (RAM_END is word aligned) */
    #define RAM_START   (uint32_t *)0x20000000
    #define RAM_END     (uint32_t *)0x20005FFC

    /* Constants necessary for Transparent March tests */
    #define CLASS_B_START   ((uint32_t *) 0x20000040)
    #define CLASS_B_END     ((uint32_t *) 0x200000BF)

    #define GotoCompilerStartUp()   { T32N0_Enable(); __iar_program_start(); }

#endif  /* __IAR_SYSTEMS_ICC__ */

#ifdef __CC_ARM  /* Keil Compiler */
    /* This is the KEIL compiler entry point, usually executed right after reset */
    extern const uint16_t __checksum;
    extern void __main(void);
    extern int $Super$$main(void);

    #define FLASH_START       ((uint8_t *) 0x00000000)
    #define FLASH_END         ((uint8_t *)(&__checksum) - 1)
    #define FLASH_SIZE        ((uint32_t)FLASH_END - (uint32_t)FLASH_START + 1)


    #define FLASH_SIZEinWORDS     (uint32_t)(FLASH_SIZE/4)
    #define STEPS_NUMBER          ((uint32_t)FLASH_SIZE/64)
    #define FLASH_BLOCK           (uint32_t)((FLASH_SIZE) / STEPS_NUMBER)
    #define FLASH_BLOCK_WORDS     (uint32_t)((FLASH_SIZEinWORDS) / STEPS_NUMBER)

    /* Constants necessary for Transparent March tests */
    #define CLASS_B_START   ((uint32_t *) 0x20000040)
    #define CLASS_B_END     ((uint32_t *) 0x200000BF)

    /* Constants necessary for RAM test (RAM_END is word aligned ) */
    #define RAM_START   (uint32_t *)0x20000000
    #define RAM_END     (uint32_t *)0x20005FFC

    #define GotoCompilerStartUp() { T32N0_Enable(); __main(); }

#endif  /* __CC_ARM */

/* Exported functions ------------------------------------------------------- */
void STL_StartUp(void);
void STL_UARTInit(void);
CPUStatus STL_StartUpCPUTest(void);
void STL_WDGSelfTest(void);
void Reset_IRQHandler(void);
void FailSafePOR(void);
ErrorStatus STL_PLLSelfTest(void);
ErrorStatus STL_FullRamMarchC(void);
uint16_t STL_crc16(uint16_t sum, uint8_t *p, uint32_t len);
uint16_t calcCRC16(uint8_t *ucpt, uint32_t ullen, uint16_t uicrc);
ClockStatus STL_ClockStartUpTest(void);
void STL_InitRunTimeChecks(void);
void STL_TranspMarchCInit(void);
void STL_FlashCrc16Init(void);
ClassBTestStatus STL_crc16Run(void);
void CRC_Init(void);
void Init_system_wdogs(void);
ClassBTestStatus STL_TranspMarchC(void);
void STL_DoRunTimeChecks(void);
CPUStatus STL_RunTimeCPUTest(void);
uint32_t CRC_CalcBlockCrc(const uint32_t *p, uint32_t len);

#endif

/******************* (C) COPYRIGHT 2018 Eastsoft *****END OF FILE****/
