#include "irqhandler.h"

void NMI_IRQHandler(void)
{
}

void HardFault_IRQHandler(void)
{
    while (1);
}

void SVC_IRQHandler(void)
{
}

void PendSV_IRQHandler(void)
{
}

void SysTick_IRQHandler(void)
{
    uint32_t RamTestResult;

    /* Verify TickCounter integrity */
    if ((TickCounter ^ TickCounterInv) == 0xFFFFFFFFuL)
    {
        TickCounter++;
        TickCounterInv = ~TickCounter;

        if (CurrentRTCPeriod < 0xFFFFFFFF)
        {
            CurrentRTCPeriod++;
            CurrentRTCPeriodInv = ~CurrentRTCPeriod;
        }

        if (TickCounter >= SYSTICK_100MS_TB)
        {
            /* Reset timebase counter */
            TickCounter = 0u;
            TickCounterInv = 0xFFFFFFFF;

            /* Set Flag read in main loop */
            TimeBaseFlag = 0xAAAAAAAAuL;
            TimeBaseFlagInv = 0x55555555uL;

            ISRCtrlFlowCnt += RAM_MARCHC_ISR_CALLER;
            __disable_irq();
            RamTestResult = STL_TranspMarchC();
            __enable_irq();
            ISRCtrlFlowCntInv -= RAM_MARCHC_ISR_CALLER;

            switch (RamTestResult)
            {
                case TEST_RUNNING:
                    break;

                case TEST_OK:
                    break;

                case TEST_FAILURE:
                case CLASS_B_DATA_FAIL:
                default:
#ifdef STL_VERBOSE_PRINTF
                    printf("\n\r >>>>>>>>>>>>>>>>>>>  RAM Error (March C- Run-time check)\n\r");
#endif
                    FailSafePOR();
                    break;
            }

            /* Do we reached the end of RAM test? */
            /* Verify 1st ISRCtrlFlowCnt integrity */
            if ((ISRCtrlFlowCnt ^ ISRCtrlFlowCntInv) == 0xFFFFFFFFuL)
            {
                if (RamTestResult == TEST_OK)           //RAM test finish
                {
                    ISRCtrlFlowCnt = 0u;
                    ISRCtrlFlowCntInv = 0xFFFFFFFFuL;
                }
            } /* End of control flow monitoring */
            else
            {
#ifdef STL_VERBOSE_PRINTF
                printf("\n\r Control Flow error in ISR \n\r");
#endif
                FailSafePOR();
            }
        }
    }
    else  /* Class B variable error on TickCounter */
    {
#ifdef STL_VERBOSE_PRINTF
        printf("\n\r Class B Error on TickCounter\n\r");
#endif
        FailSafePOR();
    }
}

/*********************************************************
: void RTC_IRQHandler(void)
  : ʵʱʱжϴ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void RTC_IRQHandler(void)
{
    if (RTC_GetFlagStatus(RTC_Interrupt_Source_Second) != RESET
            && RTC_GetITStatus(RTC_Interrupt_Source_Second) != RESET)   //жԴʱͬʱжIEIF
    {
        RTC_ClearITPendingBit(RTC_Interrupt_Source_Second);    //жϱʶ

        if (AbandonTimes != 0)
        {
            AbandonTimes--;
            AbandonTimesInv = AbandonTimes;
        }
        else
        {
            LastRTCPeriod = CurrentRTCPeriod;
            LastRTCPeriodInv = ~LastRTCPeriod;
        }

        CurrentRTCPeriod = 0u;
        CurrentRTCPeriodInv = 0xFFFFFFFFuL;
    }
}

/*********************************************************
: void T16N0_IRQHandler(void)
  : T16N0ʱжϺ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T16N0_IRQHandler(void)
{
    uint32_t i;

    if (T16Nx_GetFlagStatus(T16N0, TIM_IF_MAT0) != RESET)
    {
        T16Nx_ClearIFPendingBit(T16N0, TIM_IF_MAT0);

        for (i = 0; i < 50; i++)
        {

        }
    }
}
