/*********************************************************
*Copyright (C), 2018, Shanghai Eastsoft Microelectronics Co., Ltd
*ļ:  main.c
*  :  Liut
*  :  V1.00
*  :  2018/06/21
*  :  CLASSB
*  ע:
          ѧϰʾʹãûֱôķջеκηΡ
**********************************************************/
#include "main.h"
#include "stdio.h"
void STL_RtcConfig(void);

/*********************************************************
: void T16N0_Init(void)
  : T16N0ʱʼ
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
void T16N0_Init(void)
{
    TIM_BaseInitStruType x;

    x.TIM_ClkS = TIM_ClkS_PCLK;
    x.TIM_SYNC = DISABLE;
    x.TIM_EDGE = TIM_EDGE_Rise;
    x.TIM_Mode = TIM_Mode_TC0;
    T16Nx_BaseInit(T16N0, &x);
    T16Nx_SetPREMAT(T16N0, 1);
    T16Nx_SetMAT0(T16N0, 1000);
    NVIC_Init(NVIC_T16N0_IRQn, NVIC_Priority_0, ENABLE);

    T16Nx_MAT0ITConfig(T16N0, TIM_Clr_Int);
    T16Nx_ITConfig(T16N0, TIM_IT_MAT0, ENABLE);
    T16N0_Enable();
}

/*********************************************************
: int main(void)
  : 
ֵ: 
ֵ: 
ֵ: 
**********************************************************/
int main(void)
{
    SystemInit();
    PLLClock_Config(ENABLE, SCU_PLL_HRC, SCU_PLL_48M, ENABLE);
    SystemCoreClock = 48000000;     //Ĭ48MHz
    DeviceClockAllEnableButIAP();

    STL_InitRunTimeChecks();
    STL_RtcConfig();
    User_SysTickInit();
    T16N0_Init();

#ifdef STL_VERBOSE_PRINTF
    STL_UARTInit();         //ӡϢӿڳʼӲIOһ
    printf("\n\n\r *******main: STL_InitRunTimeChecks *******\n\r");
#endif

    while (1)
    {
        /* Add your application tasks here  */

        if (TimeBaseFlag == 0xAAAAAAAAuL)
        {
            STL_DoRunTimeChecks();

            TimeBaseFlag = 0;
            TimeBaseFlagInv = ~TimeBaseFlag;
        }
    }
}
